# yolov8
## 论文
无

## 模型结构
yolov8是一种单阶段目标检测算法，该算法在YOLOV5的基础上添加了一些新的改进思路，使其速度与精度都得到了极大的性能提升。<br>
![block.jpg](./block.jpg)

## 算法原理
YOLOv8算法通过将图像划分为不同大小的网格，预测每个网格中的目标类别和边界框，利用特征金字塔结构和自适应的模型缩放来实现高效准确的实时目标检测。
- 骨干网络和 Neck 部分将 YOLOv5 的 C3 结构换成了梯度流更丰富的 C2f 结构，并对不同尺度模型调整了不同的通道数，大幅提升了模型性能。
- Head 部分相比 YOLOv5 改动较大，换成了目前主流的解耦头结构，将分类和检测头分离，同时也从 Anchor-Based 换成了 Anchor-Free.
- Loss 计算方面采用了 TaskAlignedAssigner 正样本分配策略，并引入了 Distribution Focal Loss.
- 训练的数据增强部分引入了 YOLOX 中的最后 10 epoch 关闭 Mosiac 增强的操作，可以有效地提升精度
![model_framework.png](./model_framework.png)

## 环境配置
### Docker
拉取镜像
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:opencv49_ffmpeg4.2.1_ubuntu20.04-dtk24.04.2
```
创建并启动容器
```
docker run -it --network=host --ipc=host  --name=yolov8_ort  --privileged --hostname localhost --shm-size=16G --device=/dev/kfd --device=/dev/mkfd --device=/dev/dri -v /opt/hyhal:/opt/hyhal:ro -v /your_code_path:/your_code_path --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined  99d476c02fdd /bin/bash
```

## 数据集
无，使用项目中的案例图像进行推理测试

## 推理
### 编译工程
```
git clone http://developer.sourcefind.cn/codes/modelzoo/yolov5s_onnxruntime.git
mkdir build && cd build
cmake ../
make
```

### 运行案例
```
./main
```

### result
更多推理结果结果请见img_out文件夹
![result.png](./img_out/bus.jpg)

### 精度
无

## 应用场景
### 算法类别
`目标检测`
### 热点应用行业
`金融、交通、教育`

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/yolov8_onnxruntime

## 参考资料
- https://github.com/ultralytics/ultralytics/tree/main/examples/YOLOv8-ONNXRuntime-CPP
- https://github.com/Li-99/yolov8_onnxruntime