# YoloV7

## 模型介绍

YOLOV7是2022年最新出现的一种YOLO系列目标检测模型，在论文 [YOLOv7: Trainable bag-of-freebies sets new state-of-the-art for real-time object detectors](https://arxiv.org/abs/2207.02696)中提出。

## 模型结构

YoloV7模型的网络结构包括三个部分：input、backbone和head。与yolov5不同的是，将neck层与head层合称为head层，实际上的功能是一样的。各个部分的功能和yolov5相同，如backbone用于提取特征，head用于预测。yolov7依旧基于anchor based的方法，同时在网络架构上增加E-ELAN层，并将REP层也加入进来，方便后续部署，同时在训练时，在head时，新增Aux_detect用于辅助检测。

## 构建安装

在光源可拉取推理的docker镜像，YoloV7工程推荐的镜像如下：

```python
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

### 安装Opencv依赖

```python
cd <path_to_migraphx_samples>
sh ./3rdParty/InstallOpenCVDependences.sh
```

### 修改CMakeLists.txt

- 如果使用ubuntu系统，需要修改CMakeLists.txt中依赖库路径：
  将"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/"修改为"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/"

- **MIGraphX2.3.0及以上版本需要c++17**


### 安装OpenCV并构建工程

```
rbuild build -d depend
```

### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

**Centos**:

```
export LD_LIBRARY_PATH=<path_to_migraphx_samples>/depend/lib64/:$LD_LIBRARY_PATH
```

**Ubuntu**:

```
export LD_LIBRARY_PATH=<path_to_migraphx_samples>/depend/lib/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

## 推理

### C++版本推理

成功编译YoloV7工程后，在build目录下输入如下命令运行该示例：

```
./MIGraphX_Samples 0
```

程序运行结束会在build目录生成YoloV7检测结果图像。

<img src="./Resource/Images/Result.jpg" alt="Result" style="zoom:50%;" />

### python版本推理

YoloV7模型的推理示例程序是YoloV7_infer_migraphx.py，使用如下命令运行该推理示例：

```
# 进入python示例目录
cd ./Python

# 安装依赖
pip install -r requirements.txt

# 运行程序
python YoloV7_infer_migraphx.py \
	--imgpath 测试图像路径 \ 
	--modelpath onnx模型路径 \
	--objectThreshold 判断是否有物体阈值，默认0.5 \
	--confThreshold 置信度阈值，默认0.25 \
	--nmsThreshold nms阈值，默认0.5 \
```

程序运行结束会在当前目录生成YoloV7检测结果图像。

<img src="./Resource/Images/Result.jpg" alt="Result_2" style="zoom: 50%;" />

## 历史版本

​		https://developer.hpccube.com/codes/modelzoo/yolov7_migraphx

## 参考

​		https://github.com/WongKinYiu/yolov7
