# YoloV7

## 论文

YOLOv7: Trainable bag-of-freebies sets new state-of-the-art for real-time object detectors

- https://arxiv.org/pdf/2207.02696.pdf

## 模型结构

YOLOV7是2022年最新出现的一种YOLO系列目标检测模型，在论文 [YOLOv7: Trainable bag-of-freebies sets new state-of-the-art for real-time object detectors](https://arxiv.org/abs/2207.02696)中提出。

<img src="./Doc/YoloV7模型结构.png" alt="YOLOV7_02" style="zoom:67%;" />

## 算法原理

YoloV7模型的网络结构包括三个部分：input、backbone和head。与yolov5不同的是，将neck层与head层合称为head层，实际上的功能是一样的。各个部分的功能和yolov5相同，如backbone用于提取特征，head用于预测。yolov7依旧基于anchor based的方法，同时在网络架构上增加E-ELAN层，并将REP层也加入进来，方便后续部署，同时在训练时，在head时，新增Aux_detect用于辅助检测。

## 环境配置

拉取镜像：

```plaintext
docker pull image.sourcefind.cn:5000/dcu/admin/base/migraphx:4.0.0-centos7.6-dtk23.04.1-py38-latest
```

创建并启动容器：

```plaintext
docker run --shm-size 16g --network=host --name=yolov7_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/yolov7_migraphx:/home/yolov7_migraphx -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

## 数据集

根据提供的样本数据，进行目标检测。

## 推理

### Python版本推理

下面介绍如何运行Python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

#### 设置环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

#### 安装依赖

```
# 进入python示例目录
cd <path_to_yolov7_migraphx>/Python

# 安装依赖
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
```

#### 运行示例

YoloV7模型的推理示例程序是YoloV7_infer_migraphx.py，在Python目录下使用如下命令运行该推理示例：

```
python YoloV7_infer_migraphx.py \
	--imgpath 测试图像路径 \ 
	--modelpath onnx模型路径 \
	--objectThreshold 判断是否有物体阈值，默认0.5 \
	--confThreshold 置信度阈值，默认0.25 \
	--nmsThreshold nms阈值，默认0.5 \
```

### C++版本推理

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。


#### 构建工程

```
rbuild build -d depend
```

#### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

```
export LD_LIBRARY_PATH=<path_to_yolov7_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

#### 运行示例

成功编译YoloV7工程后，执行如下命令运行该示例：

```
# 进入yolov7 migraphx工程根目录
cd <path_to_yolov7_migraphx> 

# 进入build目录
cd ./build/

# 执行示例程序
./YOLOV7
```

## result

### Python版本

python程序运行结束后，会在当前目录生成目标检测图像。

<img src="./Resource/Images/Result.jpg" alt="Result_2" style="zoom: 50%;" />

### C++版本

C++程序运行结束后，会在build目录生成目标检测图像。

<img src="./Resource/Images/Result.jpg" alt="Result" style="zoom:50%;" />

## 应用场景

### 算法类别

`目标检测`

### 热点应用行业

`交通`,`教育`,`化工`

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/yolov7_migraphx

## 参考

https://github.com/WongKinYiu/yolov7
