#include <CommonUtility.h>

namespace migraphxSamples
{

bool CompareConfidence(const ResultOfDetection& L, const ResultOfDetection& R)
{
    return L.confidence > R.confidence;
}

bool CompareArea(const ResultOfDetection& L, const ResultOfDetection& R)
{
    return L.boundingBox.area() > R.boundingBox.area();
}

void NMS(std::vector<ResultOfDetection>& detections, float IOUThreshold)
{
    // sort
    std::sort(detections.begin(), detections.end(), CompareConfidence);

    for(int i = 0; i < detections.size(); ++i)
    {
        if(detections[i].exist)
        {
            for(int j = i + 1; j < detections.size(); ++j)
            {
                if(detections[j].exist)
                {
                    // compute IOU
                    float intersectionArea =
                        (detections[i].boundingBox & detections[j].boundingBox).area();
                    float intersectionRate =
                        intersectionArea / (detections[i].boundingBox.area() +
                                            detections[j].boundingBox.area() - intersectionArea);

                    if(intersectionRate > IOUThreshold)
                    {
                        detections[j].exist = false;
                    }
                }
            }
        }
    }
}

} // namespace migraphxSamples
