#ifndef __DETECTOR_YOLOV7_H__
#define __DETECTOR_YOLOV7_H__

#include <migraphx/program.hpp>

#include <CommonDefinition.h>

namespace migraphxSamples
{

typedef struct _YOLOV7Parameter
{
    int numberOfClasses;
    float confidenceThreshold;
    float nmsThreshold;
    float objectThreshold;

}YOLOV7Parameter;

class DetectorYOLOV7
{
public:
    DetectorYOLOV7();
    
    ~DetectorYOLOV7();

    ErrorCode Initialize(InitializationParameterOfDetector initializationParameterOfDetector);

    ErrorCode Detect(const cv::Mat &srcImage, std::vector<ResultOfDetection> &resultsOfDetection);

private:
    cv::FileStorage configurationFile;

    migraphx::program net;
    cv::Size inputSize;
    std::string inputName;
    migraphx::shape inputShape;
    
    bool useFP16;
    std::vector<std::string> classNames;

    YOLOV7Parameter yolov7Parameter;
};

}

#endif
