# Yolov7-tiny

## 论文
`Trainable bag-of-freebies sets new state-of-the-art for real-time object detectors`
- https://arxiv.org/pdf/2207.02696.pdf
## 模型结构
YOLOv7-tiny先将图片经过输入部分数据增强等一系列操作进行预处理后，被送入主干网，主干网部分对处理后的图片提取特征；随后，提取到的特征经过Neck模块特征融合处理得到大、中、小三种尺寸的特征；最终，融合后的特征被送入检测头，经过检测之后输出得到结果。

![img](./docs/yolov7.jpeg)
## 算法原理
YOLOv7的作者提出了 Extended-ELAN (E-ELAN)结构。E-ELAN采用了ELAN类似的特征聚合和特征转移流程，仅在计算模块中采用了类似ShuffleNet的分组卷积、扩张模块和混洗模块，最终通过聚合模块融合特征。通过采用这种方法可以获得更加多样的特征，同时提高参数的计算和利用效率。

![img](./docs/yolov7.png)
## 环境配置
### Docker（方法一）
```
triton server端：
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:tritonserver-2.37.0dev_dtk-23.04-ubuntu22.04.1-py38
# <your IMAGE ID>用以上拉取的docker的镜像ID替换
docker run --shm-size 10g --network=host --name=tritonserver --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -it <your IMAGE ID> bash
triton client端：
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:tritonclient-2.37.0dev_dtk-23.04-ubuntu22.04.2-py310
# <your IMAGE ID>用以上拉取的docker的镜像ID替换
docker run --shm-size 10g --network=host --name=tritonclient --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -it <your IMAGE ID> bash
```
### Dockerfile（方法二）

```
# server端:
cd ./docker
docker build -f Dockerfile_server --no-cache -t triton:server .

docker run --shm-size 16g --network=host --name=tritonserver --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -it <Your Image ID> /bin/bash

# client端:
docker build -f Dockerfile_client --no-cache -t triton:client .

docker run --shm-size 16g --network=host --name=tritonclient --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -it <Your Image ID> /bin/bash
```

## 推理

### server端运行
```
进入server容器
cd /opt/tritonserver/
./bin/tritonserver --model-repository=./models/
```
运行完之后server端会等待client端发送推理请求

### client推理请求
```
进入client容器
cd /workspace/client/build/install/bin
./yolov7-tiny yolov7-tiny /workspace/images/bus.jpg
```
运行yolov7-tiny模型，对bus.jpg图片进行目标检测.

## result
![img](./docs/result.jpg)

## 应用场景
### 算法类别
`目标检测`
### 热点应用行业
`制造,环境,医疗,气象`
## 源码仓库及问题反馈
- http://developer.hpccube.com/codes/modelzoo/yolov7-tiny_triton.git
## 参考资料
- https://github.com/triton-inference-server/server.git
- https://github.com/triton-inference-server/client.git
- https://github.com/triton-inference-server/python_backend.git
- https://github.com/triton-inference-server/onnxruntime_backend.git
