from tvm import testing
import onnx
testing.utils.install_request_hook(depth=3)
# sphinx_gallery_end_ignore
from PIL import Image
import numpy as np
from tvm.relay.transform import InferType, ToMixedPrecision
import tvm
from tvm import relay, auto_scheduler
import tvm.relay.testing
from tvm.contrib import graph_executor


 
    

#数据格式转换目前支持NCHW及NHWC两种格式
img_data = np.random.rand(1,3,640,640).astype("float32")/255
input_name = "images"
shape_dict = {input_name: img_data.shape}
model_path = './yolov5s.onnx'
onnx_model = onnx.load(model_path)
# Define the neural network and compilation target

batch_size = 1
layout = "NCHW"
target = "rocm -libs=miopen,rocblas"
dtype = "float32"
mod, params = relay.frontend.from_onnx(onnx_model, shape_dict, dtype=dtype)


# Compile with the history best
print("Compile...")
#mod = tvm.relay.transform.ToMixedPrecision(mixed_precision_type='float16', missing_op_mode=1)(mod)
with tvm.transform.PassContext(opt_level=3):
    lib = relay.build(mod, target=target, params=params)
print('Compile success!')

dev = tvm.device(str(target), 0)
module = graph_executor.GraphModule(lib["default"](dev))
module.set_input(input_name, img_data)

# Evaluate
print("Evaluate inference time cost...")
print(module.benchmark(dev, repeat=100, min_repeat_ms=500))
