# YOLOV5S

## 论文

[Comprehensive Guide to Ultralytics YOLOv5 - Ultralytics YOLOv8 Docs](https://docs.ultralytics.com/yolov5/)

## 模型结构

YOLOv5 是一种目标检测算法，采用单阶段（one-stage）的方法，基于轻量级的卷积神经网络结构，通过引入不同尺度的特征融合和特征金字塔结构来实现高效准确的目标检测。其中YOLOV5s是YOLOv5系列中的一个较小版本。

![Backbone](Backbone.png)

## 算法原理

YOLOv5 是一种基于单阶段目标检测算法，通过将图像划分为不同大小的网格，预测每个网格中的目标类别和边界框，利用特征金字塔结构和自适应的模型缩放来实现高效准确的实时目标检测。其中YOLOV5s是YOLOv5系列中的一个较小版本。

![Algorithm_principle](Algorithm_principle.png)

## 环境配置
### Docker(方法一)
此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:tvm_fp32_dtk22.10.1_py38_centos-7.6-latest
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
cd /root/tvm-0.11-dev0/apps/
git clone http://developer.hpccube.com/codes/modelzoo/yolov5s_tvm.git
```

## 数据集

COCO2017（在网络良好的情况下，如果没有下载数据集，程序会默认在线下载数据集）

[训练数据](http://images.cocodataset.org/zips/train2017.zip)

[验证数据](http://images.cocodataset.org/zips/val2017.zip)

[测试数据](http://images.cocodataset.org/zips/test2017.zip)

[标签数据](https://github.com/ultralytics/yolov5/releases/download/v1.0/coco2017labels.zip)

数据集的目录结构如下：

```
├── images 
│   ├── train2017
│   ├── val2017
│   ├── test2017
├── labels
│   ├── train2017
│   ├── val2017
├── annotations
│   ├── instances_val2017.json
├── LICENSE
├── README.txt 
├── test-dev2017.txt
├── train2017.txt
├── val2017.txt

```

## 推理

CPP Deploy测试参考：
```
    cd yolov5s_tvm
    mkdir lib
    ulimit -s unlimited
    export MIOPEN_DEBUG_CONV_IMPLICIT_GEMM=0
    export HIP_VISIBLE_DEVICES=2(此处修改为对应加速卡ID号)
    python3 prepare_test_libs.py
    bash run_example.sh
```
Python Deploy测试参考：
```
    bash run_python.sh
```
### result
![result](result.jpg)

## 精度

测试数据：COCO2017，使用的加速卡:Z100L。
```
 Average Precision  (AP) @[ IoU=0.50      | area=   all | maxDets=100 ] = 0.571
 Average Precision  (AP) @[ IoU=0.75      | area=   all | maxDets=100 ] = 0.401
 Average Precision  (AP) @[ IoU=0.50:0.95 | area= small | maxDets=100 ] = 0.216
 Average Precision  (AP) @[ IoU=0.50:0.95 | area=medium | maxDets=100 ] = 0.423
 Average Precision  (AP) @[ IoU=0.50:0.95 | area= large | maxDets=100 ] = 0.489
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=   all | maxDets=  1 ] = 0.311
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=   all | maxDets= 10 ] = 0.516
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=   all | maxDets=100 ] = 0.566
 Average Recall     (AR) @[ IoU=0.50:0.95 | area= small | maxDets=100 ] = 0.378
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=medium | maxDets=100 ] = 0.627
 Average Recall     (AR) @[ IoU=0.50:0.95 | area= large | maxDets=100 ] = 0.719
Results saved to runs/val/exp59
```
## 应用场景
### 算法类别
目标检测

### 热点行业
金融,交通,教育

### 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/yolov5s_tvm

### 参考

https://github.com/ultralytics/yolov5/
