# YOLOV5S(You Only Look Once version 5 small)
## 模型介绍

YOLOv5s是一种目标检测模型，是YOLOv5系列中的一个较小版本。它是由Ultralytics公司开发的，使用PyTorch框架实现,相比于之前的YOLOv3和YOLOv4，YOLOv5s在速度和精度上都有了显著的提高，同时模型大小也有所减小。这使得YOLOv5s成为了一种非常优秀的目标检测模型，能够在较短的时间内处理大量的目标检测任务。

## 模型结构

YOLOv5s的模型结构主要由以下几个部分组成：

Backbone：骨干网络采用了CSPDarknet53结构，其中CSP指的是Cross Stage Partial连接，能够提高模型的效率和准确率。

Neck：采用了SPP（Spatial Pyramid Pooling）和PAN（Path Aggregation Network）来增强模型的感受野，并提高对目标的检测能力。

Head：输出层包含三个不同大小的检测头，用于检测不同大小的目标。每个检测头都会输出特定大小的锚框和类别概率，然后进行筛选和调整，最终输出检测结果。

Training Strategy：采用了一种新的训练策略，称为Mosaic数据增强，通过将多张图片随机拼接来进行训练，从而提高模型的鲁棒性和泛化能力。

## 模型文件 

根据实际需要下载yolov5s.onnx文件

## 数据集

示例中验证的数据集来自：
```
https://github.com/ultralytics/yolov5/releases/download/v1.0/coco128.zip
```

## 推理 

### 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练的docker镜像：

* 推理镜像：
```
  docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:tvm-0.11_fp32_cpp_dtk22.10_py38_centos-7.6-latest
```
* 激活镜像环境及运行测试
```
  cd /tvm-0.11-dev0/apps/howto_deploy.yolov5s 
 
```
### 单卡测试

CPP Deploy测试参考：
```
    prepare_test_libs.py
    bash run_example.sh
```
Python Deploy测试参考：
```
    python yolov5s_infer.py
```
## 准确率数据

参考result.jpg

## 源码仓库及问题反馈

* https://developer.hpccube.com/codes/modelzoo/yolov5s_tvm 

## 参考

* https://developer.hpccube.com/codes/modelzoo/yolov5s_tvm 

