#include "main.h"
#include <sys/time.h>
#include "DetectorYOLOV5.h"

void Ort_DetectorYOLOV5()
{
    const std::string modelPath = "../Resource/Models/Yolov5/yolov5s_b4.onnx";
    const std::string keysPath = "../Resource/Models/Yolov5/coco.names";

    DetectorYOLOV5 detector;
    detector.setNumThread(1);
    detector.setGpuIndex(0);
    detector.initModel(modelPath, keysPath);
    
    std::vector<int64_t> resize_shape = detector.getshape();

    const int batch_size = 4;
    
    // 注意路径后面的‘/’
    std::string imagePath = "../Resource/Images/";
    std::string _strPattern = imagePath + "*.jpg";  // test_images
    std::vector<cv::String> imageNames;
    cv::glob(_strPattern, imageNames);
    std::vector<cv::Mat> imagebatch;

    for (int i = 0; i < batch_size; i++)
    {
        cv::Mat image = cv::imread(imageNames[i], 1);
        if (image.empty()) {
            std::cout << "No image found.";
        }
        // cv::resize(image, image, cv::Size(width, height));
        imagebatch.push_back(image);
    }

    double time1 = getTickCount();
    detector.Detect(imagebatch, imageNames);
    double time2 = getTickCount();
    double elapsedTime = (time2 - time1)*1000 / getTickFrequency();
    fprintf(stdout, "inference time: %.3f ms\n", elapsedTime);

    return;
}
