#ifndef __COMMON_UTILS_H__
#define __COMMON_UTILS_H__

#include <opencv2/core.hpp>
#include <onnxruntime_cxx_api.h>
#include <numeric>
#include <sys/stat.h>

std::vector<float> substractMeanNormalize(cv::Mat &src, const float *meanVals, const float *normVals);

std::vector<Ort::AllocatedStringPtr> getInputNames(Ort::Session *session);

std::vector<int64_t> getInputDim(Ort::Session *session);

std::vector<Ort::AllocatedStringPtr> getOutputNames(Ort::Session *session);

std::string getSrcImgFilePath(const char *path, const char *imgName);
#endif
