# YoloV5

## 论文
yolov5无论文，参考github源项目：https://github.com/ultralytics/yolov5


## 模型结构
YOLOv5 是一种目标检测算法，采用单阶段（one-stage）的方法，基于轻量级的卷积神经网络结构，通过引入不同尺度的特征融合和特征金字塔结构来实现高效准确的目标检测。

![Backbone](Backbone.png)

## 算法原理
YOLOv5 是一种基于单阶段目标检测算法，通过将图像划分为不同大小的网格，预测每个网格中的目标类别和边界框，利用特征金字塔结构和自适应的模型缩放来实现高效准确的实时目标检测。

![Algorithm_principle](Algorithm_principle.png)

## 环境配置
### Docker（方法一）
拉取镜像：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:opencv49_ffmpeg4.2.1_ubuntu20.04-dtk24.04.2
```

创建并启动容器：

```
docker run -it --network=host --ipc=host  --name=yolov5s_ort  --privileged --hostname localhost --shm-size=16G --device=/dev/kfd --device=/dev/mkfd --device=/dev/dri -v /opt/hyhal:/opt/hyhal:ro -v /your_code_path:/your_code_path --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined  99d476c02fdd /bin/bash
```
### Dockerfile（方法二）
```
cd ./docker
docker build --no-cache -t yolov5_ort .
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
```

### Anaconda (方法三)
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/
```
DTK软件栈：dtk24.04.2
python：python3.10
torch：2.1.0
torchvision：0.16.0
```

Tips：以上dtk软件栈、python、torch等DCU相关工具版本需要严格一一对应

2、安装ffmpeg2.4.1
```
wget https://ffmpeg.org/releases/ffmpeg-4.2.1.tar.bz2
tar -xjf ffmpeg-4.2.1.tar.bz2
cd ffmpeg-4.2.1

# 编译
./configure \
    --prefix=/usr/local \
    --enable-gpl \
    --enable-libx264 \
    --enable-libx265 \
    --enable-libvpx \
    --enable-libfdk-aac \
    --enable-libmp3lame \
    --enable-libopus \
    --enable-libass \
    --enable-libtheora \
    --enable-libvorbis \
    --enable-nonfree

make -j$(nproc)
sudo make install
```
3、安装opencv4.9.0

```
git clone --branch 4.9.0 --depth=1 https://github.com/opencv/opencv.git

# setp2：安装依赖包（如果有的包apt源中找不到，忽略即可。影响不大）
——————————————————————————————————————————————————————————————————————————————————————
# 安装编译器
sudo apt-get install build-essential

# 【必须】安装CMake等依赖包
# 安装cmake、git和pkg-config
sudo apt-get install cmake git pkg-config libgtk2.0-dev pkg-config libavcodec-dev libavformat-dev libswscale-dev

# 【可选】安装常用图像工具包 

# 安装openCV数值优化函数包
sudo apt-get install libatlas-base-dev gfortran

# 安装图像相关包
sudo apt-get install python-dev python-numpy libtbb2 libtbb-dev libjpeg-dev libpng-dev libtiff-dev libjasper-dev libdc1394-22-dev
——————————————————————————————————————————————————————————————————————————————————————

# step3：编译 详细的cmake参数定义需要多看参考博文
cd opencv
mkdir build&& cd build
cmake -D CMAKE_BUILD_TYPE=Release -D CMAKE_INSTALL_PREFIX=/usr/local/ -D FFMPEG=ON -D OPENCV_GENERATE_PKGCONFIG=YES -D WITH_1394=OFF -D OPENCV_ENABLE_NONFREE=ON -D BUILD_opencv_videoio=ON -D BUILD_opencv_highgui=ON ..
make -j8 # 几个线程编

# step4：安装
make install

```


## 数据集
无，使用提供的案例图像进行测试

## 推理
### 编译工程
```
git clone http://developer.sourcefind.cn/codes/modelzoo/yolov5s_onnxruntime.git
cd yolov5s_onnxruntime
mkdir build && cd build
cmake ../
make
```

### 运行示例
```
./yolov5
```

## result
该项目为多batch推理，单张图片推理结果如下，所有推理结果位于./build/下：

![img](bus.jpg)

### 精度
无

## 应用场景
### 算法类别
目标检测

### 热点应用行业
监控,交通,教育

## 源码仓库及问题反馈
- http://developer.hpccube.com/codes/modelzoo/video_ort.git

## 参考资料
- https://github.com/ultralytics/yolov5/
