# YOLOV5

## 论文

无论文

## 模型结构

YOLOv5 是一种目标检测算法，采用单阶段（one-stage）的方法，基于轻量级的卷积神经网络结构，通过引入不同尺度的特征融合和特征金字塔结构来实现高效准确的目标检测。

![Backbone](Backbone.png)

## 算法原理

YOLOv5 是一种基于单阶段目标检测算法，通过将图像划分为不同大小的网格，预测每个网格中的目标类别和边界框，利用特征金字塔结构和自适应的模型缩放来实现高效准确的实时目标检测。

![Algorithm_principle](Algorithm_principle.png)

## 环境配置

### Docker (方法一)

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10

docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /opt/hyhal:/opt/hyhal:ro --name docker_name imageID bash

cd /path/workspace/
pip3 install -r requirements.txt
```

### Dockerfile (方法二)

```
cd ./docker
docker build --no-cache -t yolov5:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true ---device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /opt/hyhal:/opt/hyhal:ro --name docker_name imageID bash
```

### Anaconda (方法三)

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.sourcefind.cn/tool/

```
DTK软件栈：dtk24.04.1
python：python3.10
torch：2.1.0
torchvision：0.16.0
```

Tips：以上dtk软件栈、python、torch等DCU相关工具版本需要严格一一对应

2、其他非特殊库直接按照requirements.txt安装

```
pip3 install -r requirements.txt
```



## 数据集

在本测试中可以使用COCO2017数据集。
- 数据集快速下载中心:
  - [SCNet AIDatasets](https://www.scnet.cn/ui/aihub/datasets)
- 数据集快速通道下载地址：
  - [数据集快速下载地址](https://www.scnet.cn/ui/aihub/datasets/yiziqinx/COCO2017)
- 官方下载地址
  - [训练数据](http://images.cocodataset.org/zips/train2017.zip)
  - [验证数据](http://images.cocodataset.org/zips/val2017.zip)
  - [测试数据](http://images.cocodataset.org/zips/test2017.zip)
  - [标签数据](https://github.com/ultralytics/yolov5/releases/download/v1.0/coco2017labels.zip)

数据集的目录结构如下：

```
├── images 
│   ├── train2017
│   ├── val2017
│   ├── test2017
├── labels
│   ├── train2017
│   ├── val2017
├── annotations
│   ├── instances_val2017.json
├── LICENSE
├── README.txt 
├── test-dev2017.txt
├── train2017.txt
├── val2017.txt

```

## 训练

在data/coco.yaml文件进行修改数据集路径。
若使用dtk版本为22.10.1及其之前的版本，训练之前请修改bn的配置：

如图将torch.backends.cudnn.enabled改为False

![native_bn](native_bn.png)

### 单机单卡

```
export HIP_VISIBLE_DEVICES=0
export USE_MIOPEN_BATCHNORM=1


python3 train.py --batch 32 --data coco.yaml --cfg 'yolov5m.yaml' --weights '' --project 'run/train' --hyp 'data/hyps/hyp.scratch-high.yaml' --epochs 1000  2>&1 | tee  yolov5m.log
```

### 单机多卡

```
#以单机四卡为例子
export HIP_VISIBLE_DEVICES=0,1,2,3
export HSA_FORCE_FINE_GRAIN_PCIE=1
export USE_MIOPEN_BATCHNORM=1

python3 -m torch.distributed.run --nproc_per_node 4 train.py --batch 128 --data coco.yaml --cfg 'yolov5m.yaml' --weights '' --project 'run/train' --hyp 'data/hyps/hyp.scratch-high.yaml' --device 0,1,2,3 --epochs 1000 2>&1 | tee  yolov5m_4.log
```

### 多机多卡

```
#下面的例子中使用两个节点，每个节点包含4张加速卡
#node 1
export HIP_VISIBLE_DEVICES=0,1,2,3
export HSA_FORCE_FINE_GRAIN_PCIE=1
export USE_MIOPEN_BATCHNORM=1

python3 -m torch.distributed.launch --nproc_per_node 4 --nnodes 2 --node_rank 0 --master_addr "node1" --master_port 34567 train.py --batch 256 --data coco.yaml --weight '' --project 'multi/train' --hyp 'data/hyps/hyp.scratch-high.yaml' --cfg 'yolov5m.yaml' --epochs 1000  2>&1 | tee  yolov5m_8.log

#node2
export HIP_VISIBLE_DEVICES=0,1,2,3
export HSA_FORCE_FINE_GRAIN_PCIE=1
export USE_MIOPEN_BATCHNORM=1

python3 -m torch.distributed.launch --nproc_per_node 4 --nnodes 2 --node_rank 1 --master_addr "node1" --master_port 34567 train.py --batch 256 --data coco.yaml --weight '' --project 'multi/train' --hyp 'data/hyps/hyp.scratch-high.yaml' --cfg 'yolov5m.yaml' --epochs 1000  2>&1 | tee  yolov5m_8.log
```

## 推理
- 可使用官方模型权重进行推理，也可使用自己训练模型权重进行推理
- 模型权重快速下载中心
  - [SCNet AIModels](https://www.scnet.cn/ui/aihub/models) 
- 模型权重快速通道下载地址
  - [模型权重快速下载地址](https://www.scnet.cn/ui/aihub/models/yiziqinx/yolov5_pytorch)
- 官方下载地址：
  - [下载地址：yolov5s.pt](https://github.com/ultralytics/yolov5/releases/download/v7.0/yolov5s.pt)
- 这里以官方模型推理举例

#### 单卡推理

```
python3 val.py --data coco.yaml --img 640 --conf 0.001 --iou 0.65 --batch-size 32 --weights yolov5s.pt --device 0
```

#### 多卡推理

```
#以四卡推理为例
python3 val.py --data coco.yaml --img 640 --conf 0.001 --iou 0.65 --batch-size 128 --weights yolov5s.pt --device 0,1,2,3
```
## result
此处以yolov5s模型进行推理测试
![bus](bus.jpg)
### 精度

|  模型   | 数据类型 | map0.5:0.95 | map0.5 |
| :-----: | :------: | :---------: | :----: |
| yolov5n |   混精   |    27.9     |  46.8  |
| yolov5s |   混精   |    37.2     |  57.1  |
| yolov5m |   混精   |    44.3     |  64.1  |
| yolov5l |   混精   |     48      |  67.3  |
| yolov5x |   混精   |    49.6     |  68.6  |

## 应用场景
### 算法分类
目标检测

### 热点应用行业
金融,交通,教育

### FAQ：

### 1、画出loss和精度曲线

如果在训练一段时间后想得到loss及map曲线，我们提供了view_code.py文件，只需要将您训练过程中--project 指定的路径写入，之后执行python3 view_code.py即可在该路径下得到曲线的图像。

### 2、pycocotools输出结果特别低问题

在训练结束或者推理结束后有时候会发现pycocotools输出的结果异常，数值会非常低，而训练过程中结果正常，如下图所示：

![pycoco错误结果](pycoco_false_result.png)

这可能是因为python或者某些库的版本没有和官方对齐，还可以对代码进行修改也可以解决问题，将val.py文件中的如图所示位置，注释掉红框部分的代码也可得到正确的结果。

![pycocotools](pycocotools.png)

## 源码仓库及问题反馈

https://developer.sourcefind.cn/codes/modelzoo/yolov5_pytorch

## 参考资料

[GitHub - ultralytics/yolov5 at v6.0](https://github.com/ultralytics/yolov5/tree/v6.0)








