# 推理Benchmark

## 一、环境准备
- 1、测试环境:
  - CUDA 10.1
  - CUDNN 7.6
  - TensorRT-6.0.1
  - PaddlePaddle v2.0.1
  - GPU分别为: Tesla V100和GTX 1080Ti和Jetson AGX Xavier
- 2、测试方式:
  - 为了方便比较不同模型的推理速度，输入采用同样大小的图片，为 3x640x640，采用 `demo/000000014439_640x640.jpg` 图片。
  - Batch Size=1
  - 去掉前100轮warmup时间，测试100轮的平均时间，单位ms/image，包括网络计算时间、数据拷贝至CPU的时间。
  - 采用Fluid C++预测引擎: 包含Fluid C++预测、Fluid-TensorRT预测，下面同时测试了Float32 (FP32) 和Float16 (FP16)的推理速度。

**注意：**  TensorRT中固定尺寸和动态尺寸区别请参考文档[TENSOR教程](TENSOR_RT.md)。由于固定尺寸下对两阶段模型支持不完善，所以faster rcnn模型采用动态尺寸测试。固定尺寸和动态尺寸支持融合的OP不完全一样，因此同一个模型在固定尺寸和动态尺寸下测试的性能可能会有一点差异。

## 二、推理速度

### 1、Linux系统
#### （1）Tesla V100

| 模型                            | backbone     | 是否固定尺寸 | 入网尺寸     | paddle_inference | trt_fp32 | trt_fp16 |
|-------------------------------|--------------|--------|----------|------------------|----------|----------|
| Faster RCNN FPN            | ResNet50    | 否      | 640x640  | 27.99            | 26.15    | 21.92    |
| Faster RCNN FPN   | ResNet50    | 否      | 800x1312 | 32.49            | 25.54    | 21.70    |
| YOLOv3           | Mobilenet\_v1 | 是      | 608x608  | 9.74             | 8.61     | 6.28     |
| YOLOv3              | Darknet53    | 是      | 608x608  | 17.84            | 15.43    | 9.86     |
| PPYOLO              | ResNet50    | 是      | 608x608  | 20.77            | 18.40    | 13.53    |
| SSD              | Mobilenet\_v1 | 是      | 300x300  | 5.17             | 4.43     | 4.29     |
| TTFNet              | Darknet53    | 是      | 512x512  | 10.14            | 8.71     | 5.55     |
| FCOS              | ResNet50    | 是      | 640x640  | 35.47            | 35.02    | 34.24    |


#### （2）Jetson AGX Xavier

| 模型                            | backbone     | 是否固定尺寸 | 入网尺寸     | paddle_inference | trt_fp32 | trt_fp16 |
|-------------------------------|--------------|--------|----------|------------------|----------|----------|
| Faster RCNN FPN            | ResNet50     | 否      | 640x640  | 169.45           | 158.92   | 119.25   |
| Faster RCNN FPN  | ResNet50     | 否      | 800x1312 | 228.07           | 156.39   | 117.03   |
| YOLOv3           | Mobilenet\_v1 | 是      | 608x608  | 48.76            | 43.83    | 18.41    |
| YOLOv3              | Darknet53    | 是      | 608x608  | 121.61           | 110.30   | 42.38    |
| PPYOLO              | ResNet50     | 是      | 608x608  | 111.80           | 99.40    | 48.05    |
| SSD              | Mobilenet\_v1 | 是      | 300x300  | 10.52            | 8.84     | 8.77     |
| TTFNet              | Darknet53    | 是      | 512x512  | 73.77            | 64.03    | 31.46    |
| FCOS              | ResNet50     | 是      | 640x640  | 217.11           | 214.38   | 205.78   |

### 2、Windows系统
#### （1）GTX 1080Ti

| 模型                            | backbone     | 是否固定尺寸 | 入网尺寸     | paddle_inference | trt_fp32 | trt_fp16 |
|-------------------------------|--------------|--------|----------|------------------|----------|----------|
| Faster RCNN FPN           | ResNet50     | 否      | 640x640  | 50.74            | 57.17    | 62.08    |
| Faster RCNN FPN  | ResNet50     | 否      | 800x1312 | 50.31            | 57.61    | 62.05    |
| YOLOv3           | Mobilenet\_v1 | 是      | 608x608  | 14.51            | 11.23    | 11.13    |
| YOLOv3             | Darknet53    | 是      | 608x608  | 30.26            | 23.92    | 24.02    |
| PPYOLO              | ResNet50     | 是      | 608x608  | 38.06            | 31.40    | 31.94    |
| SSD              | Mobilenet\_v1 | 是      | 300x300  | 16.47            | 13.87    | 13.76    |
| TTFNet              | Darknet53    | 是      | 512x512  | 21.83            | 17.14    | 17.09    |
| FCOS              | ResNet50     | 是      | 640x640  | 71.88            | 69.93    | 69.52    |
