# 数据准备

数据对于深度学习开发起到了至关重要的作用，数据采集和标注的质量是提升业务模型效果的重要因素。本文档主要介绍PaddleDetection中如何进行数据准备，包括采集高质量数据方法，覆盖多场景类型，提升模型泛化能力；以及各类任务数据标注工具和方法，并在PaddleDetection下使用

## 数据采集
在深度学习任务的实际落地中，数据采集往往决定了最终模型的效果，对于数据采集的几点建议如下：

### 确定方向
任务类型、数据的类别和目标场景这些因素决定了要收集什么数据，首先需要根据这些因素来确定整体数据收集的工作方向。

### 开源数据集
在实际场景中数据采集成本其实十分高昂，完全靠自己收集在时间和金钱上都有很高的成本，开源数据集是帮助增加训练数据量的重要手段，所以很多时候会考虑加入一些相似任务的开源数据。在使用中请遵守各个开源数据集的license规定的使用条件。

### 增加场景数据
开源数据一般不会覆盖实际使用的的目标场景，用户需要评估开源数据集中已包含的场景和目标场景间的差异，有针对性地补充目标场景数据，尽量让训练和部署数据的场景一致。

### 类别均衡
在采集阶段，也需要尽量保持类别均衡，帮助模型正确学习到目标特征。


## 数据标注及格式说明

| 任务类型  |     数据标注   |   数据格式说明 |
|:--------:| :--------:|:--------:|
|    目标检测   |   [文档链接](DetAnnoTools.md)  |    [文档链接](PrepareDetDataSet.md)  |
|    关键点检测   |   [文档链接](KeyPointAnnoTools.md)  |    [文档链接](PrepareKeypointDataSet.md)  |
|    多目标跟踪   |   [文档链接](MOTAnnoTools.md)  |    [文档链接](PrepareMOTDataSet.md)  |
