# yolov5

## 论文

无论文

## 模型结构

YOLOv5 是一种目标检测算法，采用单阶段（one-stage）的方法，基于轻量级的卷积神经网络结构，通过引入不同尺度的特征融合和特征金字塔结构来实现高效准确的目标检测。

![Backbone.png](asserts%2FBackbone.png)

## 算法原理

YOLOv5 是一种基于单阶段目标检测算法，通过将图像划分为不同大小的网格，预测每个网格中的目标类别和边界框，利用特征金字塔结构和自适应的模型缩放来实现高效准确的实时目标检测。

![Algorithm_principle.png](asserts%2FAlgorithm_principle.png)

## 环境配置

### Docker (方法一)

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/paddlepaddle:2.4.2-centos7.6-dtk-23.04-py38-latest

docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /path/workspace/
pip3 install -r requirements.txt
```

### Dockerfile (方法二)

```
cd ./docker
docker build --no-cache -t yolov5_paddle:last .
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
```

### Anaconda (方法三)

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/

```
DTK软件栈：dtk23.04
python：python3.8
paddle：2.4.2
```

Tips：以上dtk软件栈、python、paddle等DCU相关工具版本需要严格一一对应

2、其他非特殊库直接按照requirements.txt安装

```
pip3 install -r requirements.txt
```



## 数据集

在本测试中可以使用COCO2017数据集。
- 数据集快速下载中心:
  - [SCNet AIDatasets](http://113.200.138.88:18080/aidatasets)
- 数据集快速通道下载地址：
  - [数据集快速下载地址](http://113.200.138.88:18080/aidatasets/coco2017)
- 官方下载地址
  - [训练数据](http://images.cocodataset.org/zips/train2017.zip)
  - [验证数据](http://images.cocodataset.org/zips/val2017.zip)
  - [测试数据](http://images.cocodataset.org/zips/test2017.zip)
  - [标签数据](https://github.com/ultralytics/yolov5/releases/download/v1.0/coco2017labels.zip)

数据集的目录结构如下：

```
├── images 
│   ├── train2017
│   ├── val2017
│   ├── test2017
├── labels
│   ├── train2017
│   ├── val2017
├── annotations
│   ├── instances_val2017.json
├── LICENSE
├── README.txt 
├── test-dev2017.txt
├── train2017.txt
├── val2017.txt

```

## 训练
- 训练数据集路径在 config/dataset/coco_detection.yml中修改dataset_dir路径
- {config}参数使用时应改为配置文件地址:  configs/yolov5/yolov5_s_300e_coco.yml [该参数可替换为其他的参数文件地址]
### 单机单卡

```
export HIP_VISIBLE_DEVICES=0
export USE_MIOPEN_BATCHNORM=1
python -m paddle.distributed.launch  tools/train.py -c {config} --amp --eval
```

### 单机多卡

```
#以单机八卡为例子
export HIP_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
export HSA_FORCE_FINE_GRAIN_PCIE=1
export USE_MIOPEN_BATCHNORM=1
python -m paddle.distributed.launch  tools/train.py -c {config} --amp --eval
```

## 推理

#### 单卡推理

```
HIP_VISIBLE_DEVICES=0 python tools/infer.py -c configs/yolov5/yolov5_s_300e_coco.yml -o weights=https://paddledet.bj.bcebos.com/models/yolov5_s_300e_coco.pdparams --infer_img=demo/000000014439_640x640.jpg
```
## result
此处以yolov5s模型进行推理测试
- 模型权重快速下载中心
  - [SCNet AIModels](http://113.200.138.88:18080/aimodels) 
- 模型权重快速通道下载地址
  - [模型权重快速下载地址](http://113.200.138.88:18080/aimodels/findsource-dependency/yolov5_paddle/-/tree/main)
- 官方下载地址：
  - [yolov5_s_300e_coco.pdparams](https://paddledet.bj.bcebos.com/models/yolov5_s_300e_coco.pdparams)

![result_000000014439_640x640.jpg](asserts%2Fresult_000000014439_640x640.jpg)
### 精度

|   模型    | 数据类型 | map0.5:0.95 | map0.5 |
|:-------:|:----:|:-----------:|:------:|
| yolov5s |  单精  |    37.0     |  56.4  |
| yolov5s |  混精  |    37.2     |  56.4  |


## 应用场景
### 算法分类
目标检测

### 热点应用行业
金融,交通,教育

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/yolov5_paddle

## 参考资料

[GitHub - Paddle_yolo](https://github.com/PaddlePaddle/PaddleYOLO)
