# YoloV5

## 论文

无

## 模型结构

YoloV5是一种单阶段目标检测算法，该算法在YOLOV4的基础上添加了一些新的改进思路，使其速度与精度都得到了极大的性能提升。

<img src=./Doc/YOLOV5_01.jpg style="zoom:100%;" align=middle>

## 算法原理

YOLOv5算法通过将图像划分为不同大小的网格，预测每个网格中的目标类别和边界框，利用特征金字塔结构和自适应的模型缩放来实现高效准确的实时目标检测。

<img src=./Doc/YOLOV5_02.png style="zoom:100%;" align=middle>

## 环境配置

### Docker（方法一）

拉取镜像：

```plaintext
docker pull image.sourcefind.cn:5000/dcu/admin/base/migraphx:4.3.0-ubuntu20.04-dtk24.04.1-py3.10
```

创建并启动容器：

```plaintext
docker run --shm-size 16g --network=host --name=yolov5_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/yolov5_migraphx:/home/yolov5_migraphx -v /opt/hyhal:/opt/hyhal:ro -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

### Dockerfile（方法二）

```
cd ./docker
docker build --no-cache -t yolov5_migraphx:2.0 .

docker run --shm-size 16g --network=host --name=yolov5_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/yolov5_migraphx:/home/yolov5_migraphx -v /opt/hyhal:/opt/hyhal:ro -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

## 数据集

根据提供的样本数据，进行目标检测。

## 推理

### Python版本推理

下面介绍如何运行Python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

#### 设置环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

#### 安装依赖

```
# 进入python示例目录
cd <path_to_yolov5_migraphx>/Python

# 安装依赖
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
```

#### 运行示例

YoloV5模型的推理示例程序是YoloV5_infer_migraphx.py，使用如下命令运行该推理示例：

```
# 进入python目录
cd <path_to_yolov5_migraphx>

# 进入Python目录
cd Python/
```

1. 静态推理

```
python YoloV5_infer_migraphx.py --staticInfer
```

2. 动态推理

```
python YoloV5_infer_migraphx.py --dynamicInfer
```

### C++版本推理

注意：当使用操作系统不一样时，CMakeList需要作相应的修改：

```
# ubuntu操作系统
${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/ 修改为 ${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/

# centos操作系统
${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/ 修改为 ${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/
```

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。


#### 构建工程

```
rbuild build -d depend
```

#### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

当操作系统是ubuntu系统时：

```
export LD_LIBRARY_PATH=<path_to_yolov3_migraphx>/depend/lib/:$LD_LIBRARY_PATH
```

当操作系统是centos系统时：

```
export LD_LIBRARY_PATH=<path_to_yolov5_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

#### 运行示例

YoloV5示例程序编译成功后，执行如下指令运行该示例：

```
# 进入yolov5 migraphx工程根目录
cd <path_to_yolov5_migraphx>

# 进入build目录
cd build/
```

1. 静态推理

```
./YOLOV5 0
```

2. 动态推理

```
./YOLOV5 1
```

## result

### Python版本

静态推理：

python程序运行结束后，会在当前目录生成YOLOV5静态推理检测结果可视化图像。

<img src="./Resource/Images/Result.jpg" alt="Result" style="zoom: 50%;" />

动态推理：

python程序运行结束后，会在当前目录生成YoloV5动态推理检测结果可视化图像。

<img src="./Resource/Images/Result0.jpg" alt="Result_2" style="zoom: 50%;" />

<img src="./Resource/Images/Result1.jpg" alt="Result1" style="zoom: 50%;" />

### C++版本

静态推理：

C++程序运行结束后，会在build目录生成YOLOV5静态推理检测结果可视化图像。

<img src="./Resource/Images/Result.jpg" alt="Result" style="zoom:50%;" />

动态推理：

C++程序运行结束后，会在build目录生成YoloV5动态shape推理检测结果可视化图像。

<img src="./Resource/Images/Result0.jpg" alt="Result" style="zoom:50%;" />

<img src="./Resource/Images/Result1.jpg" alt="Result" style="zoom:50%;" />

### 精度

无

## 应用场景

### 算法类别

`目标检测`

### 热点应用行业

`交通`,`教育`,`化工`

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/yolov5_migraphx

## 参考资料

https://github.com/ultralytics/yolov5
