# YoloV5

## 模型介绍

YoloV5是一种单阶段目标检测算法，该算法在YOLOV4的基础上添加了一些新的改进思路，使其速度与精度都得到了极大的性能提升。

## 模型结构

YoloV5模型的主要改进思路有以下几点：

- 输入端的Mosaic数据增强、自适应锚框计算、自适应图像缩放操作；
- 主干网络的Focus结构与CSP结构；
- Neck端的FPN+PAN结构；
- 输出端的损失函数GIOU_Loss以及预测框筛选的DIOU_nms。

## Python版本推理

下面介绍如何运行Python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

### 下载镜像

在光源可拉取推理的docker镜像，YoloV5工程推荐的镜像如下：

```python
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

### 设置Python环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

### 安装依赖

```
# 进入python示例目录
cd <path_to_yolov5_migraphx>/Python

# 安装依赖
pip install -r requirements.txt
```

### 运行示例

YoloV5模型的推理示例程序是YoloV5_infer_migraphx.py，本示例执行YOLOV5动态shape推理，在Python目录下使用如下命令运行该推理示例：

```
# 开启环境变量
export MIGRAPHX_DYNAMIC_SHAPE=1

# 运行示例
python YoloV5_infer_migraphx.py \
	--imgpath 测试图像路径 \ 
	--modelpath onnx模型路径 \
	--objectThreshold 判断是否有物体阈值，默认0.5 \
	--confThreshold 置信度阈值，默认0.25 \
	--nmsThreshold nms阈值，默认0.5 \
```

程序运行结束会在当前目录生成YoloV5检测结果图像。

<img src="./Resource/Images/Result0.jpg" alt="Result_2" style="zoom: 50%;" />

<img src="./Resource/Images/Result1.jpg" alt="Result1" style="zoom: 50%;" />

## C++版本推理

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。

### 下载镜像

在光源中下载MIGraphX镜像： 

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

### 安装Opencv依赖

```python
cd <path_to_migraphx_samples>
sh ./3rdParty/InstallOpenCVDependences.sh
```

### 修改CMakeLists.txt

- 如果使用ubuntu系统，需要修改CMakeLists.txt中依赖库路径：
  将"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/"修改为"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/"

- **MIGraphX2.3.0及以上版本需要c++17**


### 安装OpenCV并构建工程

```
rbuild build -d depend
```

### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

**Centos**:

```
export LD_LIBRARY_PATH=<path_to_yolov5_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

**Ubuntu**:

```
export LD_LIBRARY_PATH=<path_to_yolov5_migraphx>/depend/lib/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

### 运行示例

成功编译YoloV5工程后，执行如下命令运行动态shape推理该示例：

```
# 进入yolov5 migraphx工程根目录
cd <path_to_yolov5_migraphx> 

# 进入build目录
cd ./build/

# 开启环境变量
export MIGRAPHX_DYNAMIC_SHAPE=1

# 执行示例程序
./YOLOV5
```

程序运行结束会在build目录生成YoloV5动态shape推理检测结果图像。

<img src="./Resource/Images/Result0.jpg" alt="Result" style="zoom:50%;" />

<img src="./Resource/Images/Result1.jpg" alt="Result" style="zoom:50%;" />

## 源码仓库及问题反馈

​		https://developer.hpccube.com/codes/modelzoo/yolov5_migraphx

## 参考

​		https://github.com/ultralytics/yolov5
