# YoloV5

## 模型介绍

YoloV5是一种单阶段目标检测算法，该算法在YOLOV4的基础上添加了一些新的改进思路，使其速度与精度都得到了极大的性能提升。

## 模型结构

YoloV5模型的主要改进思路有以下几点：

- 输入端的Mosaic数据增强、自适应锚框计算、自适应图像缩放操作；
- 主干网络的Focus结构与CSP结构；
- Neck端的FPN+PAN结构；
- 输出端的损失函数GIOU_Loss以及预测框筛选的DIOU_nms。

## 构建安装

在光源可拉取推理的docker镜像，YoloV5工程推荐的镜像如下：

```python
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

### 安装Opencv依赖

```python
cd <path_to_migraphx_samples>
sh ./3rdParty/InstallOpenCVDependences.sh
```

### 修改CMakeLists.txt

- 如果使用ubuntu系统，需要修改CMakeLists.txt中依赖库路径：
  将"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/"修改为"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/"

- **MIGraphX2.3.0及以上版本需要c++17**


### 安装OpenCV并构建工程

```
rbuild build -d depend
```

### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

**Centos**:

```
export LD_LIBRARY_PATH=<path_to_migraphx_samples>/depend/lib64/:$LD_LIBRARY_PATH
```

**Ubuntu**:

```
export LD_LIBRARY_PATH=<path_to_migraphx_samples>/depend/lib/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

## 推理

### C++版本推理

成功编译YoloV5工程后，在build目录下输入如下命令运行该示例：

```
./MIGraphX_Samples 0
```

程序运行结束会在build目录生成YoloV5检测结果图像。

<img src="./Resource/Images/Result.jpg" alt="Result" style="zoom:50%;" />

### python版本推理

YoloV5模型的推理示例程序是YoloV5_infer_migraphx.py，使用如下命令运行该推理示例：

```
# 进入python示例目录
cd ./Python

# 安装依赖
pip install -r requirements.txt

# 运行程序
python YoloV5_infer_migraphx.py \
	--imgpath 测试图像路径 \ 
	--modelpath onnx模型路径 \
	--objectThreshold 判断是否有物体阈值，默认0.5 \
	--confThreshold 置信度阈值，默认0.25 \
	--nmsThreshold nms阈值，默认0.5 \
```

程序运行结束会在当前目录生成YoloV5检测结果图像。

<img src="./Resource/Images/Result.jpg" alt="Result_2" style="zoom: 50%;" />

## 历史版本

​		https://developer.hpccube.com/codes/modelzoo/yolov5_migraphx

## 参考

​		https://github.com/ultralytics/yolov5
