# YoloV5

## 模型介绍

YoloV5是一种单阶段目标检测算法，该算法在YOLOV4的基础上添加了一些新的改进思路，使其速度与精度都得到了极大的性能提升。

## 模型结构

YoloV5模型的主要改进思路有：

- 输入端的Mosaic数据增强、自适应锚框计算、自适应图像缩放操作；
- 主干网络的Focus结构与CSP结构；
- Neck端的FPN+PAN结构；
- 输出端的损失函数GIOU_Loss以及预测框筛选的DIOU_nms。

## 推理

### 环境配置

在[光源](https://www.sourcefind.cn/#/image/dcu/custom)可拉取用于推理的docker镜像，YoloV5模型推理推荐的镜像如下：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort_dcu_1.14.0_migraphx2.5.2_dtk22.10.1
```

在[光合开发者社区](https://cancon.hpccube.com:65024/4/main/)可下载MIGraphX安装包，python依赖安装：

```
pip install -r requirements.txt
```

### 运行示例

YoloV5模型的推理示例程序是YoloV5_infer_migraphx.py，使用如下命令运行该推理示例：

```
python YoloV5_infer_migraphx.py \
	--imgpath 测试图像路径 \ 
	--modelpath onnx模型路径 \
	--objectThreshold 判断是否有物体阈值，默认0.5 \
	--confThreshold 置信度阈值，默认0.25 \
	--nmsThreshold nms阈值，默认0.5 \
```

程序运行结束会在当前目录生成YoloV5检测结果图像。

<img src="./images/Result.jpg" alt="Result" style="zoom: 50%;" />

## 历史版本

​		https://developer.hpccube.com/codes/modelzoo/yolov5_migraphx

## 参考

​		https://github.com/ultralytics/yolov5
