#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <YOLOV3.h>
#include <SimpleLog.h>
#include <Filesystem.h>

int main()
{
    // 创建YOLOV3检测器
    migraphxSamples::DetectorYOLOV3 detector;
    migraphxSamples::InitializationParameterOfDetector initParamOfDetectorYOLOV3;
    initParamOfDetectorYOLOV3.configFilePath = CONFIG_FILE;
    migraphxSamples::ErrorCode errorCode=detector.Initialize(initParamOfDetectorYOLOV3);
    if(errorCode!=migraphxSamples::SUCCESS)
    {
        LOG_ERROR(stdout, "fail to initialize detector!\n");
        exit(-1);
    }
    LOG_INFO(stdout, "succeed to initialize detector\n");

    // 读取测试图片
    cv::Mat srcImage=cv::imread("../Resource/Images/dog.jpg",1);

    // 推理
    std::vector<migraphxSamples::ResultOfDetection> predictions;
    detector.Detect(srcImage,predictions);

    // 获取推理结果
    LOG_INFO(stdout,"========== Detection Results ==========\n");
    for(int i=0;i<predictions.size();++i)
    {
        migraphxSamples::ResultOfDetection result=predictions[i];
        cv::rectangle(srcImage,result.boundingBox,cv::Scalar(0,255,255),2);

        std::string label = cv::format("%.2f", result.confidence);
        label = result.className + " " + label;
        int left = predictions[i].boundingBox.x;
        int top = predictions[i].boundingBox.y;
        int baseLine;
        cv::Size labelSize = cv::getTextSize(label, cv::FONT_HERSHEY_SIMPLEX, 0.5, 1, &baseLine);
        top = max(top, labelSize.height);
        cv::putText(srcImage, label, cv::Point(left, top-10), cv::FONT_HERSHEY_SIMPLEX, 1, cv::Scalar(0, 255, 255), 2);

        LOG_INFO(stdout,"box:%d %d %d %d,label:%d,confidence:%f\n",predictions[i].boundingBox.x,
        predictions[i].boundingBox.y,predictions[i].boundingBox.width,predictions[i].boundingBox.height,predictions[i].classID,predictions[i].confidence);
    }
    cv::imwrite("Result.jpg",srcImage);
    LOG_INFO(stdout,"Detection results have been saved to ./Result.jpg\n");
    
    return 0;
}