#ifndef __DETECTOR_YOLOV3_H__
#define __DETECTOR_YOLOV3_H__

#include <migraphx/program.hpp>
#include <CommonDefinition.h>

namespace migraphxSamples
{

typedef struct _YOLOV3Parameter
{
    int numberOfClasses;
    float confidenceThreshold;
    float nmsThreshold;
    float objectThreshold;

}YOLOV3Parameter;

class DetectorYOLOV3
{
public:
    DetectorYOLOV3();
    
    ~DetectorYOLOV3();

    ErrorCode Initialize(InitializationParameterOfDetector initializationParameterOfDetector);

    ErrorCode Detect(const cv::Mat &srcImage, std::vector<ResultOfDetection> &resultsOfDetection);

private:
    cv::FileStorage configurationFile;

    migraphx::program net;
    cv::Size inputSize;
    std::string inputName;
    migraphx::shape inputShape;
    
    bool useFP16;
    std::vector<std::string> classNames;

    YOLOV3Parameter yolov3Parameter;
};

}


#endif

