# YoloV3

## 模型介绍

YOLOV3是由Joseph Redmon和Ali Farhadi在2018年提出的单阶段目标检测模型，主要用于自然场景的目标检测。

## 模型结构

算法基本思想首先通过特征提取网络对输入提取特征，backbone部分由YOLOV2时期的Darknet19进化至Darknet53加深了网络层数，引入了Resnet中的跨层加和操作；然后结合不同卷积层的特征实现多尺度训练，一共有13x13、26x26、52x52三种分辨率，分别用来预测大、中、小的物体；每种分辨率的特征图将输入图像分成不同数量的格子，每个格子预测B个bounding box，每个bounding box预测内容包括: Location(x, y, w, h)、Confidence Score和C个类别的概率，因此YOLOv3输出层的channel数为B*(5 + C)。YOLOv3的loss函数也有三部分组成：Location误差，Confidence误差和分类误差。参考论文地址：https://arxiv.org/abs/1804.02767

## python版本推理

下面介绍如何运行python代码示例，具体推理代码解析，在Doc/Tutorial_Python.md中有详细说明。

### 拉取镜像

在光源可拉取推理的docker镜像，YoloV3工程推荐的镜像如下：

```python
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

### 推理示例

YoloV3模型的推理示例程序是YoloV3_infer_migraphx.py，使用如下命令运行该推理示例：

```
# 进入python示例目录
cd ./Python

# 安装依赖
pip install -r requirements.txt

# 运行程序
python YoloV3_infer_migraphx.py \
	--imgpath 测试图像路径 \ 
	--modelpath onnx模型路径 \
	--objectThreshold 判断是否有物体阈值，默认0.4 \
	--confThreshold 置信度阈值，默认0.2 \
	--nmsThreshold nms阈值，默认0.4 \
```

程序运行结束会在当前目录生成YoloV3检测结果图像。

<img src="./Resource/Images/Result_1.jpg" alt="Result_2" style="zoom: 50%;" />



## C++版本推理

下面介绍如何运行C++代码示例，具体推理代码解析，在Doc/Tutorial_Cpp.md目录中有详细说明。

参考Python版本推理中的构建安装，在光源中拉取推理的docker镜像。

### 安装Opencv依赖

```python
cd <path_to_migraphx_samples>
sh ./3rdParty/InstallOpenCVDependences.sh
```

### 修改CMakeLists.txt

- 如果使用ubuntu系统，需要修改CMakeLists.txt中依赖库路径：
  将"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/"修改为"${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/"

- **MIGraphX2.3.0及以上版本需要c++17**


### 安装OpenCV并构建工程

```
rbuild build -d depend
```

### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

**Centos**:

```
export LD_LIBRARY_PATH=<path_to_migraphx_samples>/depend/lib64/:$LD_LIBRARY_PATH
```

**Ubuntu**:

```
export LD_LIBRARY_PATH=<path_to_migraphx_samples>/depend/lib/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

### 推理示例

成功编译YoloV3工程后，执行如下命令运行该示例：

```
# 进入migraphx samples工程根目录
cd <path_to_migraphx_samples> 

# 进入build目录
cd ./build/

# 执行示例程序
./YOLOV3
```

程序运行结束会在build目录生成YoloV3检测结果图像。

<img src="./Resource/Images/Result_1.jpg" alt="Result" style="zoom:50%;" />

## 历史版本

​		https://developer.hpccube.com/codes/modelzoo/yolov3_migraphx

## 参考

​		https://github.com/ultralytics/yolov3
