# YoloV3

## 论文

YOLOv3: An Incremental Improvement

- https://arxiv.org/abs/1804.02767

## 模型结构

YOLOV3是由Joseph Redmon和Ali Farhadi在2018年提出的单阶段目标检测模型，主要用于自然场景的目标检测。

<img src="./Doc/YOLOV3_01.jpg" style="zoom:100%;" align=middle>

## 算法原理

Yolov3算法的基本思想：首先通过特征提取网络对输入提取特征，backbone部分由YOLOV2时期的Darknet19进化至Darknet53加深了网络层数，引入了Resnet中的跨层加和操作；然后结合不同卷积层的特征实现多尺度训练，一共有13x13、26x26、52x52三种分辨率，分别用来预测大、中、小的物体；每种分辨率的特征图将输入图像分成不同数量的格子，每个格子预测B个bounding box，每个bounding box预测内容包括: Location(x, y, w, h)、Confidence Score和C个类别的概率，因此YOLOv3输出层的channel数为B*(5 + C)。YOLOv3的loss函数也有三部分组成：Location误差，Confidence误差和分类误差。

<img src="./Doc/YOLOV3_02.png" style="zoom:100%;" align=middle>



## 环境配置

### Docker（方法一）

拉取镜像：

```plaintext
docker pull image.sourcefind.cn:5000/dcu/admin/base/migraphx:4.0.0-centos7.6-dtk23.04.1-py38-latest
```

创建并启动容器：

```plaintext
docker run --shm-size 16g --network=host --name=yolov3_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/yolov3_migraphx:/home/yolov3_migraphx -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

### Dockerfile（方法二）

```
cd ./docker
docker build --no-cache -t yolov3_migraphx:2.0 .

docker run --shm-size 16g --network=host --name=yolov3_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/yolov3_migraphx:/home/yolov3_migraphx -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

## 数据集

根据提供的样本数据，进行目标检测。

## 推理

### Python版本推理

下面介绍如何运行Python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

#### 设置环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

#### 安装依赖

```
# 进入python示例目录
cd <path_to_yolov3_migraphx>/Python

# 安装依赖
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
```

#### 运行示例

YoloV3模型的推理示例程序是YoloV3_infer_migraphx.py，在Python目录下使用如下命令运行该推理示例：

```
python YoloV3_infer_migraphx.py \
	--imgpath 测试图像路径 \ 
	--modelpath onnx模型路径 \
	--objectThreshold 判断是否有物体阈值，默认0.4 \
	--confThreshold 置信度阈值，默认0.2 \
	--nmsThreshold nms阈值，默认0.4 \
```

### C++版本推理

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。


#### 构建工程

```
rbuild build -d depend
```

#### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

```
export LD_LIBRARY_PATH=<path_to_yolov3_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

#### 运行示例

成功编译YoloV3工程后，执行如下命令运行该示例：

```
# 进入yolov3 migraphx工程根目录
cd <path_to_yolov3_migraphx> 

# 进入build目录
cd ./build/

# 执行示例程序
./YOLOV3
```

## result

### Python版本

python程序运行结束后，会在当前目录生成目标检测图像。

<img src="./Resource/Images/Result_1.jpg" alt="Result_2" style="zoom: 50%;" />

### C++版本

C++程序运行结束后，会在build目录生成目标检测图像。

<img src="./Resource/Images/Result_1.jpg" alt="Result" style="zoom:50%;" />

### 精度

无

## 应用场景

### 算法类别

`目标检测`

### 热点应用行业

`交通`,`教育`,`化工`

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/yolov3_migraphx

## 参考资料

https://github.com/ultralytics/yolov3
