# YoloV3

## 模型介绍

YOLOV3是由Joseph Redmon和Ali Farhadi在2018年提出的单阶段目标检测模型，主要用于自然场景的目标检测。

## 模型结构

算法基本思想首先通过特征提取网络对输入提取特征，backbone部分由YOLOV2时期的Darknet19进化至Darknet53加深了网络层数，引入了Resnet中的跨层加和操作；然后结合不同卷积层的特征实现多尺度训练，一共有13x13、26x26、52x52三种分辨率，分别用来预测大、中、小的物体；每种分辨率的特征图将输入图像分成不同数量的格子，每个格子预测B个bounding box，每个bounding box预测内容包括: Location(x, y, w, h)、Confidence Score和C个类别的概率，因此YOLOv3输出层的channel数为B*(5 + C)。YOLOv3的loss函数也有三部分组成：Location误差，Confidence误差和分类误差。参考论文地址：https://arxiv.org/abs/1804.02767

## 推理

### 环境配置

在[光源](https://www.sourcefind.cn/#/image/dcu/custom)可拉取用于推理的docker镜像，YoloV3模型推理推荐的镜像如下：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort_dcu_1.14.0_migraphx2.5.2_dtk22.10.1
```

在[光合开发者社区](https://cancon.hpccube.com:65024/4/main/)可下载MIGraphX安装包，python依赖安装：

```
pip install -r requirements.txt
```

### 运行示例

YoloV3模型的推理示例程序是YoloV3_infer_migraphx.py，使用如下命令运行该推理示例：

```
python YoloV3_infer_migraphx.py \
	--imgpath 测试图像路径 \ 
	--modelpath onnx模型路径 \
	--objectThreshold 判断是否有物体阈值，默认0.4 \
	--confThreshold 置信度阈值，默认0.2 \
	--nmsThreshold nms阈值，默认0.4 \
```

程序运行结束会在当前目录生成YOLOV3检测结果图像。

<img src="./images/Result.jpg" alt="Result" style="zoom: 67%;" />

## 历史版本

​		https://developer.hpccube.com/codes/modelzoo/yolov3_migraphx

## 参考

​		https://github.com/ultralytics/yolov3
