#include <Sample.h>
#include <opencv2/dnn.hpp>
#include <SimpleLog.h>
#include <Filesystem.h>
#include <DetectorYOLOV3.h>
#include <fstream>


using namespace std;
using namespace cv;
using namespace cv::dnn;
using namespace migraphx;
using namespace migraphxSamples;


void Sample_DetectorYOLOV3()
{
    // 创建YOLOV3检测器
    DetectorYOLOV3 detector;
    InitializationParameterOfDetector initParamOfDetectorYOLOV3;
    initParamOfDetectorYOLOV3.parentPath = "";
    initParamOfDetectorYOLOV3.configFilePath = CONFIG_FILE;
    initParamOfDetectorYOLOV3.logName = "";
    ErrorCode errorCode=detector.Initialize(initParamOfDetectorYOLOV3);
    if(errorCode!=SUCCESS)
    {
        LOG_ERROR(stdout, "fail to initialize detector!\n");
        exit(-1);
    }
    LOG_INFO(stdout, "succeed to initialize detector\n");

    // 读取测试图片
    Mat srcImage=imread("../Resource/Images/dog.jpg",1);

    // 推理
    std::vector<ResultOfDetection> predictions;
    double time1 = getTickCount();
    detector.Detect(srcImage,predictions);
    double time2 = getTickCount();
    double elapsedTime = (time2 - time1)*1000 / getTickFrequency();
    LOG_INFO(stdout, "inference time:%f ms\n", elapsedTime);

    // 获取推理结果
    LOG_INFO(stdout,"========== Detection Results ==========\n");
    for(int i=0;i<predictions.size();++i)
    {
        ResultOfDetection result=predictions[i];
        cv::rectangle(srcImage,result.boundingBox,Scalar(0,255,255),2);

        LOG_INFO(stdout,"box:%d %d %d %d,label:%d,confidence:%f\n",predictions[i].boundingBox.x,
        predictions[i].boundingBox.y,predictions[i].boundingBox.width,predictions[i].boundingBox.height,predictions[i].classID,predictions[i].confidence);
    }
    imwrite("Result.jpg",srcImage);
    LOG_INFO(stdout,"Detection results have been saved to ./Result.jpg\n");
}