#ifndef __DETECTOR_YOLOV3_H__
#define __DETECTOR_YOLOV3_H__

#include <string>
#include <migraphx/program.hpp>
#include <opencv2/opencv.hpp>
#include <CommonDefinition.h>

using namespace std;
using namespace cv;
using namespace migraphx;

namespace migraphxSamples
{

typedef struct _YOLOV3Parameter
{
    int numberOfClasses;
    float confidenceThreshold;
    float nmsThreshold;
    float objectThreshold;

}YOLOV3Parameter;

class DetectorYOLOV3
{
public:
    DetectorYOLOV3();
    
    ~DetectorYOLOV3();

    ErrorCode Initialize(InitializationParameterOfDetector initializationParameterOfDetector);

    ErrorCode Detect(const cv::Mat &srcImage, std::vector<ResultOfDetection> &resultsOfDetection);

private:
    ErrorCode DoCommonInitialization(InitializationParameterOfDetector initializationParameterOfDetector);

private:
    cv::FileStorage configurationFile;
    InitializationParameterOfDetector initializationParameter;
    FILE *logFile;

    migraphx::program net;
    cv::Size inputSize;
    string inputName;
    migraphx::shape inputShape;
    
    bool useFP16;
    vector<string> classNames;

    YOLOV3Parameter yolov3Parameter;
};

}


#endif

