# YOLOv10
提出了无NMS训练的一致双重分配，与YOLOv9-C相比，YOLOv10-B在相同性能下的延迟减少了46%，参数减少了25%。
## 论文
`YOLOv10: Real-Time End-to-End Object Detection`
- https://arxiv.org/pdf/2405.14458

## 模型结构
YOLOv10通过Fork YOLOv8魔改而成，主体结构仍为YOLOv8，加入了一些修改的优化计算量的CIB、attention模块，同时将之前的one-to-many变为辅助one-to-one训练的正样本策略，使得在推理阶段可以去掉NMS来减小计算量。
<div align=center>
    <img src="./doc/structure.png"/>
</div>

## 算法原理
yolov10将图片数据送入模型后，沿用yolo系列的通用方法，依次通过backbone、neck提取特征，然后经过head预测出检测框。
<div align=center>
    <img src="./doc/algorithm.png"/>
</div>

## 环境配置
```
mv yolov10_pytorch yolov10 # 去框架名后缀
```

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310
# <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：c85ed27005f2
docker run -it --shm-size=32G -v $PWD/yolov10:/home/yolov10 -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name yolov10 <your IMAGE ID> bash
cd /home/yolov10
pip install -r requirements.txt # requirements.txt
```
### Dockerfile（方法二）
```
cd yolov10/docker
docker build --no-cache -t yolov10:latest .
docker run --shm-size=32G --name yolov10 -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/../../yolov10:/home/yolov10 -it yolov10 bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt。
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.sourcefind.cn/tool/
```
DTK驱动:dtk24.04
python:python3.10
torch:2.1.0
torchvision:0.16.0
onnxruntime:1.15.0
```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
pip install -r requirements.txt # requirements.txt
```

## 数据集
`COCO2017`
- http://cocodataset.org/#download

数据集快速下载中心：[SCNet AIDatasets](https://www.scnet.cn/ui/aihub/datasets) ，项目中数据集可从快速下载通道下载：[COCO2017](https://www.scnet.cn/ui/aihub/datasets/yiziqinx/COCO2017) 。

项目中已提供用于试验训练的迷你数据集，使用[`coco128.zip`](./coco128.zip)即可，也可利用训练时的自动下载获取：
```
# 将coco128.zip放到../datasets/下后训练代码会自动解压并调用
cp coco128.zip /home/datasets/
```
训练数据目录结构如下，用于正常训练的完整数据集请按此目录结构进行制备：
```
/home/datasets/coco
            ├── annotations/
            │   ├── instances_train2017.json
            │   ├── instances_val2017.json
            │   └── ...
            ├── train2017/
            │   ├── xxx.png
            │   ├── xxx.png
            │   └── ...
            ├── val2017/
            │   ├── xxx.png
            │   ├── xxx.png
            │   └── ...
```
数据集快速下载中心：[SCNet AIDatasets](https://www.scnet.cn/ui/aihub/datasets) ，项目中数据集可从快速下载通道下载：[COCO2017](https://www.scnet.cn/ui/aihub/datasets/yiziqinx/COCO2017) 。

## 训练
### 单机多卡
训练所需初始化权重从[`pt.zip`](./pt.zip)解压或从yolov10 github下载到yolov10根目录即可。

```
python train.py #以yolov10s进行示例
# 使用完整coco2017训练对train.py做以下修改即可：
# model.train(data='coco128.yaml', model='yolov10s.yaml', epochs=500, batch=256, imgsz=640, device='0,1,2,3')
model.train(data='coco.yaml', model='yolov10s.yaml', epochs=500, batch=256, imgsz=640, device='0,1,2,3')
```
更多资料可参考源项目的[`README_origin`](./README_origin.md)

## 推理
```
python predict.py
```

## result
`输入：`
```
/home/yolov10/ultralytics/assets/bus.jpg #见下图
/home/yolov10/ultralytics/assets/zidane.jpg
```
<div align=center>
    <img src="./doc/bus.png"/>
</div>

`输出：`
```
image 1/2 /home/yolov10/ultralytics/assets/bus.jpg: 640x480 4 persons, 1 bus, 1 stop sign
image 2/2 /home/yolov10/ultralytics/assets/zidane.jpg: 384x640 2 persons, 1 tie
```

### 精度
max epoch为500，推理框架：pytorch。

|  device   |   mAP50-95   |
|:---------:|:-------:|
| DCU K100  | 0.451 |
| GPU V100S | 0.451 |

## 应用场景
### 算法类别
`目标检测`
### 热点应用行业
`制造,电商,医疗,能源,教育`
## 源码仓库及问题反馈
- http://developer.sourcefind.cn/codes/modelzoo/yolov10_pytorch.git
## 参考资料
- https://github.com/THU-MIG/yolov10.git

