---
comments: true
description: Discover the enhanced features of Ultralytics HUB Pro Plan including 200GB storage, cloud training, and more. Learn how to upgrade and manage your account balance.
keywords: Ultralytics HUB, Pro Plan, upgrade guide, cloud training, storage, inference API, team collaboration, account balance
---

# Ultralytics HUB Pro

[Ultralytics HUB](https://www.ultralytics.com/hub) offers the Pro Plan as a monthly or annual subscription.

The Pro Plan provides early access to upcoming features and includes enhanced benefits:

- 200GB of storage, compared to the standard 20GB.
- Access to our [Cloud Training](./cloud-training.md).
- Access to our [Dedicated Inference API](./inference-api.md#dedicated-inference-api).
- Increased rate limits for our [Shared Inference API](./inference-api.md#shared-inference-api).
- Collaboration features for [teams](./teams.md).

## Upgrade

You can upgrade to the Pro Plan from the [Billing & License](https://hub.ultralytics.com/settings?tab=billing) tab on the [Settings](https://hub.ultralytics.com/settings) page by clicking on the **Upgrade** button.

![Ultralytics HUB screenshot of the Settings page Billing & License tab with an arrow pointing to the Upgrade button](https://github.com/ultralytics/docs/releases/download/0/ultralytics-hub-settings-upgrade-button.avif)

Next, select the Pro Plan.

![Ultralytics HUB screenshot of the Upgrade dialog with an arrow pointing to the Select Plan button](https://github.com/ultralytics/docs/releases/download/0/hub-pro-upgrade-select-plan.avif)

!!! tip

    You can save 20% if you choose the annual Pro Plan.

    ![Ultralytics HUB screenshot of the Upgrade dialog with an arrow pointing to the Save 20% toggle and one to the Select Plan button](https://github.com/ultralytics/docs/releases/download/0/hub-pro-upgrade-save-20-toggle.avif)

Fill in your details during the checkout.

![Ultralytics HUB screenshot of the Checkout with an arrow pointing to the checkbox for saving the payment information for future purchases](https://github.com/ultralytics/docs/releases/download/0/hub-pro-upgrade-save-payment-info.avif)

!!! tip

    We recommend ticking the checkbox to save your payment information for future purchases, facilitating easier top-ups to your account balance.

That's it!

![Ultralytics HUB screenshot of the Payment Successful dialog](https://github.com/ultralytics/docs/releases/download/0/payment-successful-dialog.avif)

## Account Balance

The account balance is used to pay for [Ultralytics Cloud Training](./cloud-training.md) resources.

In order to top up your account balance, simply click on the **Top-Up** button.

![Ultralytics HUB screenshot of the Settings page Billing & License tab with an arrow pointing to the Top-Up button](https://github.com/ultralytics/docs/releases/download/0/hub-pro-account-balance-top-up-button.avif)

Next, set the amount you want to top-up.

![Ultralytics HUB screenshot of the Checkout with an arrow pointing to the Change amount button](https://github.com/ultralytics/docs/releases/download/0/hub-pro-account-balance-change-amount.avif)

That's it!

![Ultralytics HUB screenshot of the Payment Successful dialog](https://github.com/ultralytics/docs/releases/download/0/payment-successful-dialog-1.avif)
