# YOLOE
YOLOE跨越多种开放Prompt机制实现了实时感知任何事物，不受限于预定义类别。

## 论文
`YOLOE: Real-Time Seeing Anything`
- https://arxiv.org/pdf/2503.07465

## 模型结构
YOLOE采用了典型的YOLOs架构，通过RepRTA支持文本Prompt，通过SAVPE支持视觉Prompt，以及通过LRPC支持无Prompt场景，YOLOs中分类头的结构将最后一个卷积层的输出通道数从闭集场景中的类别数更改为嵌入维度，以支持文本和视觉Prompt。
<div align=center>
    <img src="./doc/yoloe.png"/>
</div>

## 算法原理
视觉Prompt旨在通过视觉线索Anchor点指示感兴趣的物体类别。
<div align=center>
    <img src="./doc/SAVPE.png"/>
</div>

## 环境配置
```
mv yoloe_pytorch yoloe # 去框架名后缀
```

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10-fixpy
# <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：6063b673703a
docker run -it --shm-size=64G -v $PWD/yoloe:/home/yoloe -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name ye <your IMAGE ID> bash

cd /home/yoloe
pip install -r requirements.txt -i https://mirrors.aliyun.com/pypi/simple
```
### Dockerfile（方法二）
```
cd /home/yoloe/docker
docker build --no-cache -t ye:latest .
docker run --shm-size=64G --name ye -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/../../yoloe:/home/yoloe -it ye bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt。
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.sourcefind.cn/tool/
```
DTK驱动:dtk2504
python:python3.10
torch:2.4.1
torchvision:0.19.1
triton:3.0.0
vllm:0.6.2
flash-attn:2.6.1
deepspeed:0.14.2
apex:1.4.0
transformers:4.46.3
```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
cd /home/yoloe
pip install -r requirements.txt -i https://mirrors.aliyun.com/pypi/simple
```

## 数据集
`无`

## 训练
无

## 推理
预训练权重目录结构：
```
/home/yoloe/
    |── pretrain/yoloe-v8l-seg.pt
    └── mobileclip_blt.pt
``` 

### 单机单卡
```
cd /home/yoloe

export HF_ENDPOINT=https://hf-mirror.com
sh infer.sh
```
更多资料可参考源项目中的[`README_origin`](./README_origin.md)。

## result
`输入: `
```
--source ultralytics/assets/bus.jpg
--names person dog cat
```

`输出:`
```
ultralytics/assets/bus-output.jpg
```
<div align=center>
    <img src="./doc/bus-output.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：pytorch。

## 应用场景
### 算法类别
`目标检测`
### 热点应用行业
`制造,电商,医疗,能源,教育`
## 预训练权重
github/HF下载地址为：[yoloe-v8l-seg](https://github.com/ultralytics/assets/releases/download/v8.3.0/yoloe-v8l-seg.pt)、[mobileclip_blt](https://huggingface.co/apple/MobileCLIP-B-LT/blob/main/mobileclip_blt.pt)

github权重可通过镜像地址用wget下载，例如：https://bgithub.xyz。
## 源码仓库及问题反馈
- http://developer.sourcefind.cn/codes/modelzoo/yoloe_pytorch.git
## 参考资料
- https://github.com/THU-MIG/yoloe.git

