from ultralytics import YOLO


# 1.train
# Load a model
model = YOLO("yolo11s.pt")

# Train the model
train_results = model.train(
    data="coco8.yaml",  # path to dataset YAML, i.e. coco2017: coco.yaml
    epochs=500,  # number of training epochs
    batch=128, # batchsize, i.e. yolo11s: 128
    imgsz=640,  # training image size
    device="0,1,2,3",  # device to run on, i.e. device=0 or device=0,1,2,3 or device=cpu
)

# Evaluate model performance on the validation set
metrics = model.val()


'''
# 2.infer
# model = YOLO("runs/detect/train/weights/last.pt") # Load custom train model
# Perform object detection on an image
results = model("bus.jpg")
results[0].show()
'''

'''
# 3.export onnx
# Export the model to ONNX format
path = model.export(format="onnx")  # return path to exported model
'''
