# YOLO11
YOLO11在CPU上提速明显，支持目标检测、实例分割、图像分类、姿态估计。
## 论文
`未发表`

## 模型结构
YOLO11与YOLOv8一致提供了五个不同尺度大小的网络，延续了YOLOv10无NMS的训练策略，引入了C3k2和C2PSA两个全新模块。
<div align=center>
    <img src="./doc/YOLO11.png"/>
</div>

## 算法原理
YOLO11将图片数据送入模型后，沿用yolo系列的通用方法，依次通过backbone、neck提取特征，然后经过head预测出检测框。
<div align=center>
    <img src="./doc/algorithm.png"/>
</div>

## 环境配置
```
mv yolo11_pytorch YOLO11 # 去框架名后缀
```

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-ubuntu22.04-dtk24.04.2-py3.10
# <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：83714c19d308
docker run -it --shm-size=64G -v $PWD/YOLO11:/home/YOLO11 -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name yolo11 <your IMAGE ID> bash
cd /home/YOLO11
pip install -r requirements.txt # requirements.txt
```
### Dockerfile（方法二）
```
cd cd /home/YOLO11/docker
docker build --no-cache -t yolo11:latest .
docker run --shm-size=64G --name yolo11 -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/../../YOLO11:/home/YOLO11 -it yolo11 bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt。
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.hpccube.com/tool/
```
DTK驱动:dtk24.04.2
python:python3.10
torch:2.3.0
torchvision:0.18.1
torchaudio:2.1.2
triton:2.1.0
flash-attn:2.0.4
deepspeed:0.14.2
apex:1.3.0
xformers:0.0.25
```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
cd /home/YOLO11
pip install -r requirements.txt # requirements.txt
```

## 数据集
[coco2017](http://113.200.138.88:18080/aidatasets/coco2017.git)、[coco2017labels-segments](http://113.200.138.88:18080/project-dependency/coco2017labels-segments.git)与[`coco8`](./datasets/coco8.zip)。

对于coco8的使用：运行训练命令时会自动从官网下载并自动解压，若因网络问题未自动下载，放到`/home/datasets/`下即可，运行训练命令时会自动解压。

对于coco2017的使用：首先解压下载的coco2017中的`train2017.zip`、`val2017.zip`，放置到新建文件夹`coco/images/`下，然后解压`coco2017labels-segments.zip`，文件会自动放到`coco`目录下面。
```
mkdir coco/images

cd coco2017
unzip train2017.zip
mv train2017 ../coco/images/
unzip val2017.zip
mv val2017 ../coco/images/

cd ..
unzip coco2017labels-segments.zip
```

本项目已提供迷你数据集`coco8`用于快速试用，完整训练的目录结构如下：
```
/home/datasets
    ├── datasets/coco8
        ├── images
            ├── train
                ├── xxx.jpg
                ...
            └── val
                ├── xxx.jpg
                ...
        └── labels
            ├── train
                ├── xxx.txt
                ...
            └── val
                ├── xxx.txt
                ...
    └── datasets/coco
        ├── train2017.txt
        ├── val2017.txt
        ├── test-dev2017.txt
        ├── images
            ├── train2017
                ├── xxx.jpg
                ...
            └── val2017
                ├── xxx.jpg
                ...
        └── labels
            ├── train2017
                ├── xxx.txt
                ...
            └── val2017
                ├── xxx.txt
                ...
```
更多资料可参考源项目的[`README_origin`](./README_origin.md)

## 训练

运行训练命令时若未自动下载字体文件，使用以下命令放置即可：
```
cp Arial.ttf /root/.config/Ultralytics/Arial.ttf
```
若遇到部分环境需要到`YOLO11`目录中读取数据集，使用以下命令放置即可：
```
cd /home/YOLO11
mv ../datasets ./
```

```
cd /home/YOLO11
python train_infer_coco.py # 若希望训练coco2017，则使用此config：data="coco.yaml"。
```

## 推理
```
yolo predict model=yolo11s.pt source='https://ultralytics.com/images/bus.jpg'
```
更多资料可参考源项目的[`README_origin`](./README_origin.md)

## result
`输入: `
```
图片：bus.jpg
```

`输出:`
```
640x480 4 persons, 1 bus
```

### 精度
DCU与GPU精度一致，推理框架：pytorch。

## 应用场景
### 算法类别
`目标检测`
### 热点应用行业
`制造,电商,医疗,能源,教育`
## 预训练权重

## 源码仓库及问题反馈
- http://developer.sourcefind.cn/codes/modelzoo/yolo11_pytorch.git
## 参考资料
- https://github.com/ultralytics/ultralytics.git
- https://docs.ultralytics.com/#where-to-start

