# Yi

## 论文
- 暂无

## 模型结构
Yi系列模型结构与llama结构基本一致，以 Transformer 架构为基础：

![img](./docs/llama.png)

## 算法原理

Yi 系列模型以双语语言模型为目标，并在 3T 多语言语料库上进行训练，成为全球最强大的 LLM 模型之一，在语言理解、常识推理、阅读理解等方面显示出前景。

![img](./docs/llama_1.png)

## 环境配置

提供光源拉取推理的docker镜像：

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10(推荐)
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:lmdeploy0.0.13_dtk23.04_torch1.13_py38
# <Image ID>用上面拉取docker镜像的ID替换
# <Host Path>主机端路径
# <Container Path>容器映射路径
docker run -it --name baichuan --shm-size=1024G  --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v <Host Path>:<Container Path> <Image ID> /bin/bash
```

镜像版本依赖：

* DTK驱动：24.04.1
* Pytorch: 2.1.0
* python: python3.10

> [!NOTE]
>
> 使用lmdeploy0.0.13_dtk23.04_torch1.13_py38如果遇到 importError:libgemm multiB int4.so: cannot open shared obiect file: No such file or directory
>
> 解决方法：
>
> ```bash
> rm /usr/local/lib/python3.8/site-packages/_turbomind.cpython-38-x86_64-linux-gnu.so
> ```



## 数据集

无

## 推理

### 源码编译安装
```bash
git clone http://developer.hpccube.com/codes/modelzoo/yi_lmdeploy.git
cd yi_lmdeploy
git submodule init && git submodule update
cd lmdeploy
mkdir build && cd build
sh ../generate.sh
make -j 32
make install
cd .. && pip uninstall lmdeploy && python3 setup.py install
```
### 模型下载

预训练权重快速下载中心:

[SCNet AIModels](http://113.200.138.88:18080/aimodels)

项目中的预训练权重快速通道下载地址：

[Yi-6B-Chat](http://113.200.138.88:18080/aimodels/Yi-6B-Chat)

[Yi-34B-Chat](http://113.200.138.88:18080/aimodels/Yi-34B-Chat)

官方下载地址：

[Yi-6B-Chat](https://huggingface.co/01-ai/Yi-6B-Chat)

[Yi-34B-Chat](https://huggingface.co/01-ai/Yi-34B-Chat) 

### 运行 
```shell
lmdeploy chat turbomind  ./path_to_yi-34b --tp 4
```

#### web页面方式交互

```shell
lmdeploy serve gradio ./path_to_yi-34b --server-name {server_ip} --server-port {port} --batch_size 32 --tp 4 --restful_api False 
```
浏览器上打开 `http://{server_ip}:{server_port}`，即可进行对话
**需要保证'{server_ip}:{server_port}'在外部浏览器中的可访问性**

#### api-server
启动server：
```shell
# --instance_num: turbomind推理实例的个数。可理解为支持的最大并发数
# --tp: 在 tensor parallel时，使用的GPU数量
lmdeploy serve api_server ./path_to_yi-34b --server-name {server_ip} --server-port {server_port} --instance_num 32 --tp 4
```
浏览器上打开 `http://{server_ip}:{server_port}`，即可访问 swagger，查阅 RESTful API 的详细信息。

可以用命令行，在控制台与 server 通信（在新启的命令行页面下执行）：
```shell
# restful_api_url 就是 api_server 产生的，即上述启动server的http://{server_ip}:{server_port}
lmdeploy serve api_client restful_api_url
```
或者，启动 gradio，在 webui 的聊天对话框中，与服务交流：
```shell
# restful_api_url 就是 api_server 产生的，比如 http://localhost:23333
# server_ip 和 server_port 是用来提供 gradio ui 访问服务的
# 例子: lmdeploy serve gradio http://localhost:23333 --server-name localhost --server-port 6006 --restful_api True
lmdeploy serve gradio restful_api_url --server-name {server_ip} --server-port {server_port} --restful_api True
```
**需要保证'{server_ip}:{server_port}'在外部浏览器中的可访问性**

关于 RESTful API的详细介绍，请参考[这份](https://developer.hpccube.com/codes/aicomponent/lmdeploy/-/blob/dtk23.04-v0.0.13/docs/zh_cn/restful_api.md)文档。

## result
![llama](docs/yi34b.gif)

### 精度

无

## 应用场景

### 算法类别

`对话问答`


### 热点应用行业

`金融,科研,教育`


## 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/yi_lmdeploy

## 参考资料
https://github.com/01-ai/Yi

https://github.com/InternLM/LMDeploy
