#!/bin/bash

deepspeed --master_port $(shuf -n 1 -i 10000-65535)  --include="localhost:4,5,6,7" /home/wanglch/projects/LLaMA-Factory/src/train.py \
    --deepspeed /home/wanglch/projects/LLaMA-Factory/deepspeed.json \
    --stage sft \
    --do_train \
    --model_name_or_path /home/wanglch/projects/XuanYuan/XuanYuan-13B-Chat \
    --dataset fingpt_sentiment \
    --dataset_dir /home/wanglch/projects/LLaMA-Factory/data \
    --template qwen \
    --finetuning_type lora \
    --lora_target all \
    --output_dir /home/wanglch/projects/saves/XuanYuan-13B-Chat/lora_multi_dtk/sft \
    --overwrite_output_dir \
    --cutoff_len 1024 \
    --preprocessing_num_workers 1 \
    --per_device_train_batch_size 1 \
    --per_device_eval_batch_size 1 \
    --gradient_accumulation_steps 1 \
    --lr_scheduler_type cosine \
    --logging_steps 10 \
    --warmup_steps 20 \
    --save_steps 100 \
    --eval_steps 10 \
    --evaluation_strategy steps \
    --load_best_model_at_end \
    --learning_rate 5e-5 \
    --num_train_epochs 1.0 \
    --max_samples 3000 \
    --val_size 0.1 \
    --ddp_timeout 180000000 \
    --plot_loss True \
    --fp16
