# XrayGLM
## 论文
暂无

## 模型结构
通用领域的大语言模型 (LLM)，例如 ChatGPT，在遵循指令和产生类似人类响应方面取得了显著的成功，这种成功间接促进了多模态大模型的研究和发展，如通用领域的多模态大模型MiniGPT-4、mPLUG-Owl、Multimodal-GPT和LLaVA ，然而，此类多模态大模型却很少出现在医学领域的研究中，阻碍了相关研究发展。visual-med-alpaca虽然在医学多模态大模型方面做出了一些很有成效的工作，然而其数据为英文诊断报告，不利于促进中文领域医学多模态大模型的研究发展。为此，我们开发了XrayGLM以解决上述问题。XrayGLM在医学影像诊断和多轮交互对话上显示出了非凡的潜力。借助ChatGPT以及公开的数据集,构造了一个X光影像-诊断报告对的医学多模态数据集；把数据集分为TP和FN。

![Alt text](./images/image2.png)

## 算法原理
诊断数据集在VisualGLM-6B进行微调训练, 最后输出对胸片的询问结果

![Alt text](./images/image1.png)

## 环境配置
### Docker(方式一)
推荐使用docker方式运行，提供拉取的docker镜像：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
docker run -dit --shm-size 80g --network=host --name=xrayglm --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10 /bin/bash
docker exec -it xrayglm  /bin/bash
```

安装docker中没有的依赖:

```
pip install -r requirements.txt  -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
```

### Dockerfile(方式二)

```
docker build -t xrayglm:latest .
docker run -dit --shm-size 80g --network=host --name=xrayglm --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro   xrayglm:latest /bin/bash
docker exec -it xrayglm   /bin/bash
```


### Conda(方式三)

1.创建conda虚拟环境：

```
conda create -n xrayglm python=3.10
conda activate xrayglm 
```

2.关于本项目DCU显卡所需的工具包、深度学习库等均可从光合开发者社区下载安装。
- [DTK 24.04.1](https://cancon.hpccube.com:65024/directlink/1/DTK-24.04.1/Ubuntu20.04.1/DTK-24.04.1-Ubuntu20.04.1-x86_64.tar.gz)
- [Pytorch 2.1](https://cancon.hpccube.com:65024/directlink/4/pytorch/DAS1.2/torch-2.1.0+das.opt1.dtk24042-cp310-cp310-manylinux_2_28_x86_64.whl)
- [DeepSpeed 0.12.3](https://download.sourcefind.cn:65024/directlink/4/deepspeed/DAS1.1/deepspeed-0.12.3+gita724046.abi1.dtk2404.torch2.1.0-cp310-cp310-manylinux_2_31_x86_64.whl)


Tips：以上dtk驱动、torch等工具版本需要严格一一对应。


3. 其它依赖库参照requirements.txt安装：

```
python setup.py install
pip install -r requirements.txt -i http://mirrors.aliyun.com/pypi/simple/ --trusted-host mirrors.aliyun.com
```

## 数据集

暂无

## 训练

暂无

## 推理

cli推理

根据需要修改预训练模型以及cli_demo.py中48行visualglm-6b模型的位置

```
python cli_demo.py --from_pretrained checkpoints/checkpoints-XrayGLM-300 --prompt_zh '详细描述这张胸部X光片的诊断结果'
```

## result

![Alt text](./images/image3.png)

### 精度

无

## 应用场景

### 算法类别
NLP
   
### 热点应用行业

科研   医疗 教育

## 预训练模型
需下载模型 xrayGLM-300和visualglm-6b模型, 预训练权重快速下载中心：SCNet AIModels 

- [checkpoints-XrayGLM-300](https://huggingface.co/wangrongsheng/XrayGLM-300)
- [visualglm-6b](https://huggingface.co/THUDM/visualglm-6b)


## 源码仓库及问题反馈


https://developer.sourcefind.cn/codes/modelzoo/xrayglm_pytorch



## 参考资料


https://github.com/WangRongsheng/XrayGLM.git





