# xLAM

## 论文

`APIGen-MT: Agentic PIpeline for Multi-Turn Data Generation via Simulated Agent-Human Interplay`

* https://arxiv.org/pdf/2504.03601

`ActionStudio: A Lightweight Framework for Data and Training of Large Action Models`

* https://arxiv.org/pdf/2503.22673

## 模型结构

模型基于Qwen2.5以及LLama3.1/3.2训练

![alt text](readme_imgs/arch.png)

## 算法原理
Multi-Head Attention是一种并行注意力机制，它通过多个子空间中的注意力头协同工作，从不同角度捕捉序列中元素之间的关系，从而增强模型的表达能力。

![alt text](readme_imgs/alg.png)

## 环境配置

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10-fixpy

    docker run --shm-size 100g --network=host --name=wan --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -r requirements.txt

    pip install -e .


### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 100g --network=host --name=wan --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash
    
    pip install -r requirements.txt

    pip install -e .

### Anaconda（方法三）

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.sourcefind.cn/tool/

```
DTK驱动:dtk25.04
python:python3.10
torch:2.4.1
triton:3.0
flash-attn:2.6.1
deepspeed:0.14.2
apex:1.4.0
transformers:4.46.3
```

2、其他非特殊库直接按照requirements.txt安装

```
pip install -r requirements.txt
pip install -e .
```

## 数据集

项目提供用于验证的数据集，位于`actionstudio/datasets/unified_data`.


## 训练

### 数据处理

1、数据转换

```bash
cd actionstudio/src/data_pipeline

python data_converters.py

cd -
```

2、数据验证（可选）

```bash
cd actionstudio/examples/trainings
bash sft_data_verifier.sh
```

注意：运行前需根据文件中指示修改相应内容。


### Lora

```bash
cd actionstudio/examples/trainings

bash sft_lora_bf16_single_pods.sh
```

注意：运行前需根据文件中指示修改相应内容。


### 全参

```bash
cd actionstudio/examples/trainings

bash sft_bf16_single_pods.sh
```

注意：运行前需根据文件中指示修改相应内容。

本项目已关闭hf模型及wandb上传，如需使用，请修改`actionstudio/src/foundation_modeling/train`中相应部分。


## 推理

```bash
python inference.py
```

## result

![alt text](readme_imgs/result.png)

### 精度

|base model|训练方式|loss|
|:---:|:---:|:---:|
|qwen2.5-1.5b-instruct|lora|0.008|

## 应用场景

### 算法类别

`对话问答`

### 热点应用行业

`电商,教育,广媒`

## 预训练权重

此处仅提供示例模型权重，更多请参考[文档](README_official.md#model-instruction)。

[Llama-xLAM-2-8b-fc-r](https://huggingface.co/Salesforce/Llama-xLAM-2-8b-fc-r)

## 源码仓库及问题反馈

* https://developer.sourcefind.cn/codes/modelzoo/xlam_pytorch

## 参考资料

* https://github.com/SalesforceAIResearch/xLAM
