# X‑Reasoner
## 论文
[X‑Reasoner](https://arxiv.org/pdf/2505.03981)

## 模型简介
X‑Reasoner是一种仅通过通用领域文本进行后训练的视觉语言模型，旨在实现泛化推理能力。该模型采用两阶段训练方法：首先使用提炼的长思维链进行监督微调，随后通过可验证奖励进行强化学习。实验表明，X‑Reasoner成功将推理能力迁移到多模态及领域外场景，在多种通用和医学基准测试中，表现优于使用领域内和多模态数据训练的现有最先进模型。
<div align=center>
    <img src="./doc/perf.jpg"/>
</div>

## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm | 0.11.0+das.opt1.alpha.dtk25042.20251225.gca4598a4 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1.0+das.opt1.dtk25042.20251224.gaa867475 |


推荐使用镜像:harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name X‑Reasoner --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-tx-1226-das1.7-py3.10-20251226 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理

```bash
## serve启动
可参考vllm_serve.sh脚本
vllm serve microsoft/X-Reasoner-7B --trust-remote-code --dtype bfloat16 -tp 1 --max-model-len 32768 --port 8010
## client访问
可参考vllm_cilent.sh
curl -X POST "http://localhost:8010/v1/chat/completions"      -H "Content-Type: application/json"     --data '{
                "model": "microsoft/X-Reasoner-7B",
                "messages": [
                        {
                                "role": "user",
                                "content": "请介绍下自己"
                        }
                ]
        }'

```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| X-Reasoner-7B | 7B | K100AI | 1 | [下载地址](https://huggingface.co/microsoft/X-Reasoner-7B) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/x-reasoner_vllm

## 参考资料
- https://github.com/microsoft/x-reasoner
