#!/bin/bash

#module load anaconda/2020.11
# module load cuda/12.1
#source activate whisper

# # 激活conda环境
# source activate /data/home/scv7ex2/run/whisper/whisper/whisper_env

# 处理数据集
# python /data/home/scv7ex2/run/whisper/whisper/Whisper-Finetune-master/aishell.py \
#     --filepath /data/home/scv7ex2/run/whisper/whisper/data_aishell.tgz
# echo "[`date`] aishell1.py执行完毕"

echo "[`date`] 开始执行finetune.py"
python /data/home/scv7ex2/run/whisper/whisper/Whisper-Finetune-master/finetune.py \
    --base_model /data/home/scv7ex2/run/whisper/whisper/whisper-base \
    --local_files_only True \
    --train_data /data/home/scv7ex2/run/whisper/whisper/dataset/train.json \
    --test_data /data/home/scv7ex2/run/whisper/whisper/dataset/test.json \
    --output_dir /data/home/scv7ex2/run/whisper/whisper/output/ \
    --num_train_epochs 3 \
    --fp16 False


echo "[`date`] finetune.py执行完毕"

python /data/home/scv7ex2/run/whisper/whisper/Whisper-Finetune-master/merge_lora.py \
    --lora_model /data/home/scv7ex2/run/whisper/whisper/output/whisper-base/checkpoint-best/ \
    --local_files_only True \
    --output_dir /data/home/scv7ex2/run/whisper/whisper/output/models/ \

echo "[`date`] merge_lora.py执行完毕"

echo "[`date`] 开始执行evaluation.py"

python /data/home/scv7ex2/run/whisper/whisper/Whisper-Finetune-master/evaluation.py \
    --model_path /data/home/scv7ex2/run/whisper/whisper/output/models/whisper-base-finetune \
    --test_data /data/home/scv7ex2/run/whisper/whisper/dataset/test.json \
    --local_files_only True \
    --metric cer

echo "[`date`] evaluation.py执行完毕"
