# WaveGlow

## 代码下载

```bash
git clone http://developer.hpccube.com/codes/xinghao/waveglow.git
cd waveglow
git submodule init
git submodule update
```

## 环境配置

### Docker

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
#-v挂载工作目录
docker run -it  --shm-size 80g --network=host --name=waveglow --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /物理机工作目录/:/容器工作目录/ image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10 /bin/bash
```

### 安装docker中没有的依赖

```bash
#安装requirement.txt中的依赖
pip3 install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
#安装requirement.txt中没有的依赖
pip install apex -i https://pypi.tuna.tsinghua.edu.cn/simple
python3 -m pip install --upgrade pip setuptools wheel
```

## 数据处理

```bash
wget https://data.keithito.com/data/speech/LJSpeech-1.1.tar.bz2
tar -xvjf LJSpeech-1.1.tar.bz2
ls LJSpeech-1.1/wavs/*.wav | tail -n+10 > train_files.txt
ls LJSpeech-1.1/wavs/*.wav | head -n10 > test_files.txt
```



## 使用预训练模型生成语音

1. 下载模型

   ```bash
   https://drive.google.com/file/d/1rpK8CzAAirq9sWZhe9nlfvxMF1dRgFbF/view
   ```

   

2. 下载梅尔频谱图

   ```
   https://drive.google.com/file/d/1g_VXK2lpP9J25dQFhQwx7doWl_p20fXA/view 
   ```

   

3. 生成语音

   ```bash
   python3 inference.py -f <(ls mel_spectrograms/*.pt) -w waveglow_256channels.pt -o . --is_fp16 -s 0.6
   ```

    

## 模型训练

### 单DCU

```bash
mkdir checkpoints
python train.py -c config.json
```

### 多DCU

```bash
mkdir checkpoints
python distributed.py -c config.json
```

将`config.json`中的`"fp16_run"改成 true` 可以使用混合精度训练。

## 模型推理

### 生成测试集的梅尔频谱图

```bash
python mel2samp.py -f test_files.txt -o . -c config.json
```

### 使用自己训练的网络推理

```bash
ls *.pt > mel_files.txt
python3 inference.py -f mel_files.txt -w checkpoints/waveglow_10000 -o . --is_fp16 -s 0.6
```
