# Wan2.2-T2V-A14B
## 论文
[Wan](https://arxiv.org/abs/2503.20314)

## 模型简介
Wan2.2是一个开放且先进的大规模视频生成模型，在Wan2.2中，重点引入了以下创新：
- 👍 有效的MoE架构：Wan2.2在视频扩散模型中引入了混合专家（MoE）架构。通过使用专门的强专家模型来分离跨时间步的去噪过程，这扩大了整个模型的容量，同时保持了相同的计算成本。
- 👍 电影级美学：Wan2.2包含精心策划的美学数据，附带详细的照明、构图、对比度、色调等标签。这使得电影风格的生成更加精确和可控，便于创建具有自定义美学偏好的视频。
- 👍 复杂的运动生成：与Wan2.1相比，Wan2.2在显著更多的数据上进行训练，图像数量增加了+65.6%，视频数量增加了+83.2%。这一扩展显著增强了模型在多个维度上的泛化能力，如运动、语义和美学，在所有开源和闭源模型中达到顶级性能。
- 👍 高效的高清晰度混合TI2V：Wan2.2 开源了一个基于我们先进的Wan2.2-VAE构建的5B模型，实现了16×16×4的压缩比。该模型支持以720P分辨率24fps的速度生成文本到视频和图像到视频，并且可以在消费级显卡如4090上运行。它是目前可用的最快的720P@24fps模型之一，能够同时服务于工业和学术领域。
该模型采用混合专家（MoE）架构构建，提供了出色的视频生成质量。在新基准Wan-Bench2.0上，该模型在大多数关键评估维度上超越了领先的商业模型。模型架构如下：
<div align=center>
    <img src="./doc/arch.png"/>
</div>

## 环境依赖
| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10 |
| transformers | 4.57.1 |
| pytorch | 2.7.1+das.opt1.dtk25042 |
| torchaudio | 2.5.1a0+d178b24 |
| torchvision | 0.22.0+das.opt1.dtk25042 |

推荐使用镜像:
- 挂载地址`-v`，`{docker_name}`和 `{docker_image_name}`根据实际模型情况修改

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.7.1-ubuntu22.04-dtk25.04.2-py3.10-alpha
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash
pip install http://10.16.4.1:8000/debug/torchaudio/dtk25.04.2-beta-bug-fix/torch251-audio/torch251-audio-fastpt/torchaudio-2.5.1a0%2Bd178b24-cp310-cp310-manylinux_2_28_x86_64.whl
pip install http://10.16.4.1:8000/debug/flash_attn/dtk25.04.2-rc1/dtk25.04-llvm0106/flash_attn-2.6.1%2Bdas.opt1.dtk2504-cp310-cp310-manylinux_2_28_x86_64.whl
cd /your_code_path/wan2.2_pytorch
pip install -r requirements.txt

```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装，其它包参照requirements.txt安装：
```
pip install -r requirements.txt
```

## 数据集

暂无

## 训练
暂无

## 推理

### transformers
#### 单机推理
1、单卡
```bash
python generate.py  --task t2v-A14B --size 832*480 --ckpt_dir ./Wan2.2-T2V-A14B --offload_model True --convert_model_dtype --prompt "Two anthropomorphic cats in comfy boxing gear and bright gloves fight intensely on a spotlighted stage."
```
2.多卡
```bash
torchrun --nproc_per_node=8 generate.py --task t2v-A14B --size 832*480 --ckpt_dir ./Wan2.2-T2V-A14B --dit_fsdp --t5_fsdp --ulysses_size 8 --prompt "Two anthropomorphic cats in comfy boxing gear and bright gloves fight intensely on a spotlighted stage."
```

## 效果展示


<div align=center>
    <video width="600" controls>
  <source src="./doc/t2v-A14B_832*480_1_Two_anthropomorphic_cats_in_comfy_boxing_gear_and__20251110_164740.mp4">
  
</video>
</div>

### 精度
DCU与GPU精度一致，推理框架：pytorch。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| Wan2.2-T2V-A14B | 14B | K100AI,BW1000 | 1 | [下载地址](https://huggingface.co/Wan-AI/Wan2.2-T2V-A14B) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/wan2.2_pytorch

## 参考资料
- https://github.com/Wan-Video/Wan2.2