# VITS:Conditional Variational Autoencoder with Adversarial Learning for End-to-End Text-to-Speech

## 论文

[VITS](https://arxiv.org/abs/2106.06103)

## 模型结构

在这项工作中，作者提出了一种并行端到端 TTS 方法，它生成的音频比目前的两阶段模型更自然。该方法采用了变异推理，并增加了归一化流和对抗训练过程，从而提高了生成模型的表现力。作者还提出了一种随机时长预测器，可根据输入文本合成具有不同节奏的语音。通过对潜在变量的不确定性建模和随机时长预测器，该的方法表达了自然的一对多关系，即一个文本输入可以用不同的音调和节奏以多种方式说话。在 LJ Speech（一个单一说话者数据集）上进行的人类主观评估（平均意见分或 MOS）表明，该方法优于最佳的公开 TTS 系统，其 MOS 可与标准答案相媲美。

![原理](1.png)
## 算法原理

先验编码器：TextEncoder由多层的transformer encoder组成，预测的结果输出均值与方差。 后验编码器：由conv1d+WN网络组成+conv1d组成。输出得到均值与方差，并且使用FLOW得到复杂分布。通过flow后的复杂分布与先验编码器后的分布进行对MAS对齐估计。得到attn硬对齐矩阵。 MAS对齐估计：通过mas（monotonic align search）硬对齐算法，将文本feature和序列帧feature进行一个硬对齐，拿到对齐矩阵Attn。MAS使用DP算法，假设一个文本feature其对应的帧序列符合一个高斯分布，通过DP算法做优化，计算出文本和序列的最优对齐矩阵。 解码器：实际就是声码器HiFi-GAN V1的生成器。应用于多人模型时，在说话人嵌入向量之后添加一个线性层，拼接到的输出隐变量。 判别器：增加了一个HiFi-GAN的多周期判别器，仅在训练的时候才起作用，用于对抗generator的训练。

## 环境配置

### Docker（方法一）

```
#拉取镜像
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
#创建容器
docker run --shm-size 80g --network=host --name=telechat --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined  -v /opt/hyhal:/opt/hyhal:ro -v <Host Path>:<Container Path> -it <Your Image ID> /bin/bash

#安装依赖
cd vits
pip install -r requirements.txt -i https://pypi.mirrors.ustc.edu.cn/simple/
apt-get install espeak
cd monotonic_align
python setup.py build_ext --inplace

```
### Dockerfile（方法二）
无

### Anaconda（方法三）

1、关于本项目 DCU 显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/

```
DTK驱动：dtk-24.04.1
python：python3.10
torch:2.1
torchvision:0.16.0
torchaudio:2.1.2
```

2、其它非特殊库参照 requirements.txt 安装

```
cd vits
pip install -r requirements.txt -i https://pypi.mirrors.ustc.edu.cn/simple/
apt-get install espeak
cd monotonic_align
python setup.py build_ext --inplace
```

## 训练

### 数据集下载与处理

- 训练任务采用 LJ Speech-1.1 数据集，下载地址：https://data.keithito.com/data/speech/LJSpeech-1.1.tar.bz2

- 下载完成后，在 vits 文件夹下创建连接：

  ```
  ln -s /path/to/LJSpeech-1.1/wavs DUMMY1
  ```

### 代码修改

- STFT：

  ```
  vim /usr/local/lib/python3.10/site-packages/torch/functional.py
  ##把第650行的 normalized, onesided, return_complex)
  ##改为
  normalized, onesided, return_complex=True)
  ```

### 单卡训练

```
bash run_single.sh
```

### 多卡训练

```
bash run_multi.sh
```

*注意，每次运行训练后，DUMMY1 目录下会多出许多 .pt 文件，如果再次训练的话会报错，所以需要每次训练后把所有的 .pt 文件给删除：

```
rm -rf DUMMY1/*.pt
```

# 应用场景
## 算法类别
语音合成
## 热点应用行业
医疗,金融,科研,教育

## 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/vits_pytorch


## 参考资料

https://github.com/jaywalnut310/vits/tree/main
