# -*- coding: utf-8 -*-
import time

import torch
from transformers import AutoModelForCausalLM, AutoTokenizer

from vita.constants import GLOBAL_WEIGHTS_PATH

model_dir = f"{GLOBAL_WEIGHTS_PATH}/Mixtral-8x7B_New/mg2hg"

tokenizer = AutoTokenizer.from_pretrained(model_dir)


# 给定的 ID 列表
id_list = [
    1,
    1587,
    28747,
    29383,
    28971,
    28518,
    32350,
    33702,
    28944,
    13,
    28733,
    28705,
    29383,
    28971,
    32569,
    32730,
    32606,
    28914,
    29050,
    35267,
    32315,
    28944,
    29383,
    28914,
    32626,
    39797,
    28971,
    32311,
    29041,
    41993,
    29958,
    46454,
    28944,
    13,
    28733,
    28705,
    29383,
    32585,
    32474,
    32599,
    32683,
    28914,
    29292,
    29824,
    35267,
    32100,
    44797,
    33089,
    29457,
    38038,
    32599,
    28914,
    32509,
    28944,
    13,
    28733,
    47068,
    32599,
    38201,
    29383,
    37676,
    28914,
    34559,
    35845,
    28924,
    29383,
    29179,
    29478,
    32599,
    41534,
    29457,
    29551,
    32599,
    35702,
    34415,
    28914,
    35845,
    28944,
    2,
    28705,
    13,
    1838,
    28747,
]
id_list = [
    28991,
    34275,
    29105,
    33216,
    30344,
    29675,
    28914,
    46018,
    29131,
    29086,
    28944,
    29087,
    29960,
    28991,
    34700,
    43072,
    28914,
    28971,
    28518,
    29046,
]
id_list = [
    28705,
    13,
    2,
    28705,
    13,
    10093,
    28747,
    51497,
    40994,
    30162,
    32980,
    39944,
    29105,
    28518,
    41772,
    28914,
    34796,
    32703,
    28924,
    29450,
    28991,
    34275,
    29105,
    33216,
    30344,
    29675,
    28914,
    46018,
    29131,
    29086,
    28944,
    29087,
    29960,
    28991,
    34700,
    43072,
    28914,
    28971,
    28518,
    29046,
    29003,
    28835,
    4712,
    28743,
    12673,
    28838,
    28914,
    46018,
    28924,
    29450,
    33778,
    31224,
    29222,
    29146,
    33280,
    29010,
    36599,
    28914,
    49363,
    29054,
    28944,
    32641,
    46018,
    29074,
    29450,
    34526,
    28914,
    32626,
    40497,
    28924,
    32590,
    28518,
    30308,
    29251,
    30912,
    29677,
    29131,
    28518,
    35545,
    28914,
    51009,
    29169,
    28944,
    13,
    29010,
    33292,
    28991,
    28924,
    32012,
    32924,
    29450,
    29440,
    34051,
    46018,
    28924,
    33837,
    46018,
    33421,
    32587,
    28914,
    33103,
    28944,
    29450,
    28991,
    28518,
    46018,
    28998,
    28518,
    36101,
    28914,
    33778,
    28924,
    29746,
    31127,
    28518,
    29310,
    35348,
    30163,
    32813,
    28914,
    31249,
    31861,
    28944,
    32663,
    46018,
    29054,
    28914,
    33114,
    29302,
    29010,
    32155,
    33053,
    28924,
    41192,
    29992,
    30163,
    42747,
    28924,
    29746,
    41192,
    29310,
    30150,
    29010,
    49460,
    29169,
    49565,
    28944,
    13,
    33238,
    33015,
    29458,
    29366,
    29366,
    28914,
    41261,
    29061,
    28914,
    36599,
    38437,
    30131,
    30631,
    28924,
    34249,
    29065,
    48245,
    29746,
    32850,
    28914,
    33857,
    28944,
    33257,
    32031,
    41772,
    28924,
    44169,
    28969,
    29824,
    34239,
    30266,
    28924,
    33837,
    35115,
    29460,
    39676,
    40016,
    29074,
    33158,
    35523,
    29276,
    28914,
    43604,
    28944,
    36286,
    28991,
    28914,
    36096,
    32557,
    28971,
    37478,
    28914,
    28924,
    33070,
    35155,
    49059,
    49550,
    28914,
    36096,
    47444,
    28924,
    29118,
    36101,
    29131,
    32813,
    28914,
    33778,
    28944,
    44488,
    28914,
    29367,
    29051,
    33151,
    33647,
    29176,
    28971,
    28518,
    36059,
    32710,
    28914,
    32703,
    32854,
    28924,
    49323,
    29010,
    32857,
    35049,
    29276,
    32789,
    28944,
    2,
]
# 将 ID 列表转换为 PyTorch 张量
id_tensor = torch.tensor(id_list)

# 使用 tokenizer 解码
decoded_text = tokenizer.decode(id_tensor, skip_special_tokens=True)

print(f"Decoded text: {decoded_text}")
