# ViT
## 论文
`An Image is Worth 16x16 Words: Transformers for Image Recognition at Scale`
- https://arxiv.org/abs/2010.11929

## 模型结构
Vision Transformer先将图像用卷积进行分块以降低计算量，再对每一块进行展平处理变成序列，然后将序列添加位置编码和cls token，再输入多层Transformer结构提取特征，最后将cls tooken取出来通过一个MLP（多层感知机）用于分类。

![img](https://developer.hpccube.com/codes/modelzoo/megatron-deepspeed-vit_pytorch/-/raw/main/doc/vit.png)

## 算法原理
图像领域借鉴《Transformer is all you need！》算法论文中的Encoder结构提取特征，Transformer的核心思想是利用注意力模块attention提取特征：

![img](https://developer.hpccube.com/codes/modelzoo/megatron-deepspeed-vit_pytorch/-/raw/main/doc/attention.png)

## 环境配置
### Docker（方法一）
```plaintext
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
# <your IMAGE ID>用以上拉取的docker的镜像ID替换
docker run --shm-size 10g --network=host --name=vit-pytorch --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined  -v /opt/hyhal:/opt/hyhal:ro -v $PWD/vit_pytorch:/home/vit_pytorch -it <your IMAGE ID> bash
pip install -r requirements.txt
```

### Dockerfile（方法二）
```plaintext
cd ViT-PyTorch/docker
docker build --no-cache -t vit-pytorch:latest .
docker run --rm --shm-size 10g --network=host --name=megatron --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /opt/hyhal:/opt/hyhal:ro -v $PWD/../../vit_pytorch:/home/vit_pytorch -it vit-pytorch:latest bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt
```

### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/

```plaintext
DTK驱动：dtk24.04.1
python：python3.10
torch:2.1.0
torchvision:0.16.0
Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应
```

2、其它非特殊库参照requirements.txt安装

```plaintext
pip install -r requirements.txt
```

## 数据集
[cifar10](http://113.200.138.88:18080/aidatasets/project-dependency/cifar)

默认会自动下载数据集到data文件夹，可将cifar-10-python.tar.gz放置在data文件夹下

```
├── batches.meta
├── data_batch_1
├── data_batch_2
├── data_batch_3
├── data_batch_4
├── data_batch_5
├── readme.html
└── test_batch
```

## 训练

下载预训练模型[ViT-B_16.npz](http://113.200.138.88:18080/aimodels/findsource-dependency/ViT-B_16.git)放在checkpoint目录下。

### 单机单卡

```
export HIP_VISIBLE_DEVICES=0
python3 -m torch.distributed.launch --nproc_per_node=1 train.py --name cifar10-100_500 --dataset cifar10 --model_type ViT-B_16 --pretrained_dir checkpoint/ViT-B_16.npz --train_batch_size 64 --num_steps 500
```

### 单机多卡

```
python3 -m torch.distributed.launch --nproc_per_node=8 train.py --name cifar10-100_500 --dataset cifar10 --model_type ViT-B_16 --pretrained_dir checkpoint/ViT-B_16.npz --train_batch_size 64 --num_steps 500
```

## result
![1695381570003](image/README/1695381570003.png)

### 精度
测试数据使用的是cifar10，使用的加速卡是DCU Z100L。

| 卡数 | 精度 |
| :------: | :------: |
| 1 | Best Accuracy=0.3051 |

## 应用场景
### 算法类别
图像分类

### 热点行业
制造,能源,交通,网安

### 源码仓库及问题反馈
- https://developer.hpccube.com/codes/modelzoo/vit_pytorch

### 参考资料
- https://github.com/jeonsworld/ViT-pytorch
