# Vision Transformer(ViT)

## 模型介绍
Vision Transformer（ViT）是一种新的基于Transformer的神经网络模型，它是由Google Brain团队提出的。ViT的主要目标是将Transformer模型应用于计算机视觉领域，以替代传统的卷积神经网络（CNN）模型。ViT模型的核心思想是将图像转换为一组序列，并将它们输入到Transformer模型中进行处理。这个序列可以通过将图像划分为不重叠的小块（称为“补丁”）来生成，然后将每个补丁的像素值摊平为一个向量。这些向量被串联成一个长序列，然后输入到Transformer模型中。与CNN模型不同，ViT模型不需要池化或卷积层来处理输入图像。相反，它使用多头自注意力层（multi-head self-attention layer）来对输入序列进行建模。这些自注意力层允许模型在序列中的任何两个位置之间进行交互和信息传递，从而更好地捕捉图像中的全局关系。最后, ViT模型可以通过一个全连接层或者平均池化层输出最终的分类结果。ViT模型相对于CNN模型具有几个优点。首先，ViT模型可以处理任意大小的图像，而CNN模型通常需要在输入图像上进行裁剪或缩放。其次，ViT模型可以更好地处理全局关系，因为每个像素都可以与其他像素进行交互。最后，ViT模型可以很容易地应用于其他任务，例如对象检测或分割，只需在输出层进行一些修改即可。总体来说，ViT模型是一种新的、有前途的计算机视觉模型，它提供了一种基于Transformer的新思路，可以在不同的视觉任务上取得很好的性能。

## 模型结构
vision transformer模型结构如下图所示主要包括三部分，patch embeding 部分、transformer encoder部分、MLP head部分。ViT将输入图片分为多个patch，再将每个patch投影为固定长度的向量送入Transformer，后续encoder的操作和原始Transformer中完全相同。但是因为对图片分类，因此在输入序列中加入一个特殊的token，该token对应的输出即为最后的类别预测。

![img](https://pic4.zhimg.com/80/v2-5afd38bd10b279f3a572b13cda399233_1440w.webp)

## 数据集

在本测试中可以使用cifar10数据集。

数据集处理方法请参考cifar10官方介绍自行处理，也可通过下面链接下载，将数据放在data目录下。

链接：链接：https://pan.baidu.com/s/1ZFMQVBGQZI6UWZKJcTYPAQ?pwd=fq3l 提取码：fq3l 

## ViT训练
### 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练以及推理的docker镜像：
* 训练镜像：docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest
* pip install -r requirements.txt

### 训练

下载预训练模型放在checkpoint目录下：

```
wget https://storage.googleapis.com/vit_models/imagenet21k/ViT-B_16.npz
```

训练命令：

    export HIP_VISIBLE_DEVICES=3
    python3 -m torch.distributed.launch --nproc_per_node=1 train.py --name cifar10-100_500 --dataset cifar10 --model_type ViT-B_16 --pretrained_dir checkpoint/ViT-B_16.npz --train_batch_size 64 --num_steps 500

## 准确率数据
测试数据使用的是cifar10，使用的加速卡是DCU Z100L。

| 卡数 | 精度 |
| :------: | :------: |
| 1 | Best Accuracy=0.3051 |
### 历史版本

https://developer.hpccube.com/codes/modelzoo/vit-pytorch

### 参考

https://github.com/jeonsworld/ViT-pytorch