# VisualGLM-6B
## 模型结构
VisualGLM 模型架构是 ViT + QFormer + ChatGLM，在预训练阶段对 QFormer 和 ViT LoRA 进行训练，在微调阶段对 QFormer 和 ChatGLM LoRA 进行训练，训练目标是自回归损失（根据图像生成正确的文本）和对比损失（输入 ChatGLM 的视觉特征与对应文本的语义特征对齐）


<div align=center>
    <img src="./doc/image.png"/>
</div>

## 算法原理
VisualGLM-6B 是一个开源的，支持图像、中文和英文的多模态对话语言模型，语言模型基于 ChatGLM-6B，具有 62 亿参数；图像部分通过训练 BLIP2-Qformer 构建起视觉模型与语言模型的桥梁，整体模型共78亿参数。
VisualGLM-6B 由 SwissArmyTransformer(简称sat) 库训练，这是一个支持Transformer灵活修改、训练的工具库，支持Lora、P-tuning等参数高效微调方法。本项目提供了符合用户习惯的huggingface接口，也提供了基于sat的接口。

结合模型量化技术，用户可以在消费级的显卡上进行本地部署（INT4量化级别下最低只需6.3G显存）。

## 环境配置
### Docker（方法一）

在光源可拉取推理的docker镜像，拉取方式如下：
```
docker pull xxx
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
cd /path/workspace/
```
### Dockerfile（方法二）
此处提供dockerfile的使用方法
```
docker build --no-cache -t xxx:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
```
### Anaconda（方法三）
此处提供本地配置、编译的详细步骤，例如：

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动：dtk23.10
python：python3.8
torch:1.13.1 
torchvision:0.14.1
deepspeed:0.12.3
```


其它非深度学习库参照requirements.txt安装：
```
pip install -r requirements.txt
```

## 推理
使用pip安装依赖
```
pip install -i https://mirrors.aliyun.com/pypi/simple/ -r requirements.txt
```
此时默认会安装deepspeed库（支持sat库训练），此库对于模型推理并非必要，同时部分Windows环境安装此库时会遇到问题。 如果想绕过deepspeed安装，我们可以将命令改为
```
pip install -i https://mirrors.aliyun.com/pypi/simple/ -r requirements_wo_ds.txt
pip install -i https://mirrors.aliyun.com/pypi/simple/ --no-deps "SwissArmyTransformer>=0.4.4"
```

使用Huggingface transformers库调用模型，可以通过如下代码（其中图像路径为本地路径,模型路径为THUDM/visulglm-6b）：
```
from transformers import AutoTokenizer, AutoModel
tokenizer = AutoTokenizer.from_pretrained("THUDM/visualglm-6b", trust_remote_code=True)
model = AutoModel.from_pretrained("THUDM/visualglm-6b", trust_remote_code=True).half().cuda()
image_path = "your image path"
response, history = model.chat(tokenizer, image_path, "描述这张图片。", history=[])
print(response)
response, history = model.chat(tokenizer, image_path, "这张图片可能是在什么场所拍摄的？", history=history)
print(response)
```
得到返回值
```
Specify both input_ids and inputs_embeds at the same time, will use inputs_embeds
这张照片中，一位女士坐在沙发上使用笔记本电脑和鼠标。她似乎正在浏览网页或工作。她的姿势表明她在放松、享受或专注于她的工作。背景中的瓶子可能暗示着饮料或其他日常用品的存在。椅子和沙发的布置也表明这是一个舒适的环境，适合休息或进行轻松的工作活动。
考虑到照片的背景和场景设置，可以推断出这个场景是一个舒适的环境中拍摄的照片，例如家庭住宅或休闲空间。这位女士坐在一张沙发上，周围有瓶子和其他物品，这表明这个地方可能有一些日常用品或装饰。这种布置可能会鼓励人们放松身心并享受他们的日常活动，比如观看电影、阅读书籍或者与亲朋好友聊天。
```
命令行 Demo
```
python cli_demo_hf.py 
```
程序会自动下载sat模型，并在命令行中进行交互式的对话，输入指示并回车即可生成回复，输入 clear 可以清空对话历史，输入 stop 终止程序。

API部署

首先需要安装额外的依赖 pip install fastapi uvicorn，然后运行仓库中的 api.py：

```
python api.py
```
程序会自动下载 sat 模型，默认部署在本地的 8080 端口，通过 POST 方法进行调用。下面是用curl请求的例子，一般而言可以也可以使用代码方法进行POST。

```
echo "{\"image\":\"$(base64 path/to/example.jpg)\",\"text\":\"描述这张图片\",\"history\":[]}" > temp.json
curl -X POST -H "Content-Type: application/json" -d @temp.json http://127.0.0.1:8080
```

得到的返回值为

```
{"result":"这张照片中，一个年轻女子坐在沙发上，手里拿着笔记本电脑。她可能正在工作或学习，或者只是放松和享受时间。","history":[["描述这张图片","这张照片中，一个年轻女子坐在沙发上，手里拿着笔记本电脑。她可能正在工作或学习，或者只是放松和享受时间。"]],"status":200,"time":"2024-01-22 11:16:35"}
```
### 精度
无
## 应用场景
### 算法类别
多模态对话
### 热点应用行业
## 源码仓库及问题反馈
- 此处填本项目gitlab地址
## 参考资料
- https://github.com/THUDM/VisualGLM-6B?tab=readme-ov-file

