# VisualGLM-6B

## 论文
无
## 模型结构
VisualGLM 模型架构是 ViT + QFormer + ChatGLM，在预训练阶段对 QFormer 和 ViT LoRA 进行训练，在微调阶段对 QFormer 和 ChatGLM LoRA 进行训练，训练目标是自回归损失（根据图像生成正确的文本）和对比损失（输入 ChatGLM 的视觉特征与对应文本的语义特征对齐）


<div align=center>
    <img src="./doc/image.png"/>
</div>

## 算法原理
VisualGLM-6B 是一个开源的，支持图像、中文和英文的多模态对话语言模型，语言模型基于 ChatGLM-6B，具有 62 亿参数；图像部分通过训练 BLIP2-Qformer 构建起视觉模型与语言模型的桥梁，整体模型共78亿参数。
VisualGLM-6B 由 SwissArmyTransformer(简称sat) 库训练，这是一个支持Transformer灵活修改、训练的工具库，支持Lora、P-tuning等参数高效微调方法。本项目提供了符合用户习惯的huggingface接口，也提供了基于sat的接口。

## 环境配置
### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:visualglm-6b_pytorch-latest 
docker run -it -v /path/your_data/:/path/your_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
```
### Dockerfile（方法二）
此处提供dockerfile的使用方法， dockerfile在docker文件夹中
```
cd docker
docker build --no-cache -t xxx:latest .
docker run -it -v /path/your_data/:/path/your_data/ --shm-size=32G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
```

## 数据集
无

### 模型下载地址
THUDM/visualglm-6b(https://huggingface.co/THUDM/visualglm-6b/tree/main)
    
## 推理

### 代码推理

进入容器后， 进行克隆 
```
git clone  https://developer.hpccube.com/codes/modelzoo/visualglm6b_pytorch
cd  visualglm6b_pytorch
```
执行推理命令
```
python test.py  #修改相关图像路径image_path和模型路径THUDM/visulglm-6b
```

### 交互式命令行推理

修改cli_demo_hf.py 中模型路径THUDM/visualglm-6b为本地模型路径
```
python cli_demo_hf.py 
```
如果不修改模型路径，程序会自动下载sat模型（由于涉及到访问外网，可能无法下载）。执行上面命令，则可以通过命令行中进行交互式的对话，输入指示并回车即可生成回复，输入 clear 可以清空对话历史，输入 stop 终止程序。

### API部署推理

首先需要安装额外的依赖，然后运行仓库中的 api.py：
```
pip install fastapi uvicorn
python api.py
```
程序会自动下载 sat 模型，默认部署在本地的 8080 端口，通过 POST 方法进行调用。下面是用curl请求的例子（修改path/to/example.jpg为本地路径），一般而言可以也可以使用代码方法进行POST。

```
echo "{\"image\":\"$(base64 path/to/example.jpg)\",\"text\":\"描述这张图片\",\"history\":[]}" > temp.json
curl -X POST -H "Content-Type: application/json" -d @temp.json http://127.0.0.1:8080
```

得到的返回值为

```
{"result":"这张照片中，一个年轻女子坐在沙发上，手里拿着笔记本电脑。她可能正在工作或学习，或者只是放松和享受时间。","history":[["描述这张图片","这张照片中，一个年轻女子坐在沙发上，手里拿着笔记本电脑。她可能正在工作或学习，或者只是放松和享受时间。"]],"status":200,"time":"2024-01-22 11:16:35"}
```

## result
推理图片的不同，会出现不同结果，下面为一个result示例：
&nbsp;
"这张照片中，一位女士坐在沙发上使用笔记本电脑和鼠标。似乎正在浏览网页或工作。她的姿势表明她在放松、享受或专注于她的工作。背景中的瓶子可能暗示着饮料或其他日常用品的存在。椅子和沙发的布置也表明这是一个舒适的环境，适合休息或进行轻松的工作活动。
考虑到照片的背景和场景设置，可以推断出这个场景是一个舒适的环境中拍摄的照片，例如家庭住宅或休闲空间。这位女士坐在一张沙发上，周围有瓶子和其他物品，这表明这个地方可能有一些日常用品或装饰。这种布置可能会鼓励人们放松身心并享受他们的日常活动，比如观看电影、阅读书籍或者与亲朋好友聊天"

### 精度
无
## 应用场景
### 算法类别
多模态对话
### 热点应用行业
图像理解   以图生文   文章生成
## 源码仓库及问题反馈
- http://developer.hpccube.com/codes/modelzoo/visualglm6b_pytorch.git
## 参考资料
- https://github.com/THUDM/VisualGLM-6B?tab=readme-ov-file

