# Vision-Transformers-cifar10_PyTorch

## 模型介绍

Vision Transformers (ViT) 是一种基于 Transformer 的视觉模型，它在图像分类任务上表现出了与当前最先进的卷积神经网络相当的性能。而ViT模型是使用Transformer架构来代替传统卷积神经网络的。ViT模型的核心思想是将输入的图像分割成数个图块（patch），然后将这些图块拼接成一个序列，再输入到Transformer中进行特征提取和分类。

## 模型结构

Vision Transformers (ViT) - CIFAR10 模型的结构基于 Transformer 的视觉模型，其核心思想是将输入的图像分割成数个图块（patch），然后将这些图块拼接成一个序列，再输入到 Transformer 中进行特征提取和分类。

具体来说，该模型的输入是一张 $32\times32$ 的彩色图像，其中每个图像被分割成 $4\times4$ 个大小为 $8\times8$ 的图块。这些图块被重塑为一个序列，并传递给 Transformer 编码器进行特征提取。在编码器中，每个序列元素（即每个图块）都经过一个多头自注意力机制（Multi-Head Self-Attention）模块和一个前馈网络模块（Feed-Forward Network）进行处理。这些模块的输出被送入下一层编码器，直到最终输出分类结果。

该模型的主要组成部分是由多个 Transformer 编码器层组成的。每个编码器层由一个多头自注意力机制模块和一个前馈网络模块组成。这些编码器层之间使用残差连接（Residual Connection）连接，以便有效地传播信息和减轻梯度消失问题。

最后，模型的输出通过一个全连接层进行分类，该层将 Transformer 编码器的输出展平为一维张量，并对其进行分类。整个模型的训练过程使用交叉熵损失函数进行优化。

## 数据集

本次使用的数据集为[CIFAR-10](https://www.cs.toronto.edu/~kriz/cifar.html)，CIFAR-10数据集由10类中的60000 32x32颜色图像组成，每个类别有6000张图像。有50000个训练图像和10000个测试图像。

该数据集分为五个训练批次和一批测试批次，每个测试批次有10000张图像。该测试批次完全包含来自每个类的1000个随机选择的图像。训练批次包含剩余的图像，但有些训练批次可能包含一个班级的图像，而不是另一个班级的图像。在他们之间，训练批次包含每个班级的5000张图像。

## 训练及推理

### 环境配置

提供光源拉取的训练镜像

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10-py38-latest
```

安装依赖：

```
pip install pandas==1.5.3
```

创建软链接

```
ln -s datasets/cifar10 data
```

若需要指定路径，也可以在工程根目录的train_cifar10.py中修改（修改130行左右的trainset和testset变量即可）

开始训练

```
bash train.sh
#默认使用四卡训练，可在train.sh脚本中修改
```

## 准确率数据

| 卡数 | 准确率 |
| :--: | :----: |
|  4   | 84.91% |



## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/vision-transformers-cifar10_pytorch

## 参考

https://github.com/kentaroy47/vision-transformers-cifar10