#ifndef __QUEUE_H__
#define __QUEUE_H__


#include <pthread.h>
#include <queue>
#include <condition_variable>
#include <mutex>
#include <sys/time.h>
#include <opencv2/opencv.hpp>
#include <Decoder.h>

using std::queue;

#define CAPACITY 1

class Queue
{
public:
    Queue(size_t Capacity = CAPACITY);
    ~Queue();
  
    void enQueue(cv::Mat& Image);
  
    void deQueue(cv::Mat* Image);

    void finish();

    bool Isempty();

    bool DecodeEnd;

private:
    bool IsFull();

    queue<cv::Mat> _Queue;
    size_t _Capacity;
    pthread_mutex_t Lock;
    pthread_cond_t ConsumeCond;
    pthread_cond_t ProductCond;
};


#endif
