#!/bin/bash
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

if [ $# -ne 1 ]; then
    echo "Two args are required: $0 index"
    echo "index:"
    echo "\t 1) YOLOV3T sample."
    echo "\t 2) YOLOV5S sample."
    echo "\t 3) YOLOV7T sample."
    exit
fi

echo "Build the libraries.."
mkdir -p lib
make
export LD_LIBRARY_PATH=/tvm-0.11-dev0/build:${LD_LIBRARY_PATH}
export DYLD_LIBRARY_PATH=/tvm-0.11-dev0//build:${DYLD_LIBRARY_PATH}
export ROCBLAS_TENSILE_LIBPATH=/opt/dtk/lib/rocblas/library/

echo "Run the example"
echo "Run the cpp deployment with all in normal library..."
if [[ $1 == '1' ]]; then
    echo "Run yolov3-tiny sample"
    ./yolov3t_deploy
elif [[ $1 == '2' ]]; then
    echo "Run yolov5s sample"
    ./yolov5s_deploy
elif [[ $1 == '3' ]]; then
    echo "Run yolov7-tiny sample"
    ./yolov7t_deploy
else
    echo "error index, please set arg to 0 / 1 / 2."
fi

