// YOLOV5检测器
#ifndef __DETECTOR_YOLOV5_H__
#define __DETECTOR_YOLOV5_H__

#include <string>
#include <fstream>
#include <onnxruntime_cxx_api.h>
#include <opencv2/opencv.hpp>
#include <opencv2/dnn.hpp>
#include "CommonUtils.h"
#include "Queuethread.h"
#include "Decoder.h"

using namespace std;
using namespace cv;

typedef struct  _ResultOfDetection
{
    Rect boundingBox;
    float confidence;
    int classID;
    string className;
    bool exist;

    _ResultOfDetection():confidence(0.0f),classID(0),exist(true){}

}ResultOfDetection;

class DetectorYOLOV5
{
public:
    ~DetectorYOLOV5();

    void setNumThread(int numOfThread);

    void setGpuIndex(int gpuIndex);

    void initModel(const std::string &pathStr, const std::string &pathOfClassNameFile);

    void Detect(cv::Mat originSrc);

private:
    Ort::Session *session;
    Ort::Env env = Ort::Env(ORT_LOGGING_LEVEL_ERROR, "Yolov5");
    Ort::SessionOptions sessionOptions = Ort::SessionOptions();
    int numThread = 0;
    vector<string> classNames;

    std::vector<int64_t> inputDim;
    std::vector<Ort::AllocatedStringPtr> inputNamesPtr;
    std::vector<Ort::AllocatedStringPtr> outputNamesPtr;

    const float meanValues[3] = {0, 0, 0};
    const float normValues[3] = {1.0 / 255.0, 1.0 / 255.0, 1.0 / 255.0};
};


#endif
